/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tenant;

import com.alibaba.rcm.Constraint;
import com.alibaba.rcm.ResourceContainer;
import com.alibaba.rcm.internal.AbstractResourceContainer;
import com.alibaba.tenant.NativeDispatcher;
import com.alibaba.tenant.TenantConfiguration;
import com.alibaba.tenant.TenantData;
import com.alibaba.tenant.TenantException;
import com.alibaba.tenant.TenantGlobals;
import com.alibaba.tenant.TenantResourceContainer;
import com.alibaba.tenant.TenantShutdownHooks;
import com.alibaba.tenant.TenantState;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import sun.misc.SharedSecrets;
import sun.misc.TenantAccess;

public class TenantContainer {
    TenantResourceContainer resourceContainer;
    private static NativeDispatcher nd = new NativeDispatcher();
    private static AtomicLong nextTenantID = new AtomicLong(0L);
    private static Map<Long, TenantContainer> tenantContainerMap = null;
    private List<Thread> attachedThreads = new LinkedList<Thread>();
    private List<WeakReference<Thread>> spawnedThreads = Collections.synchronizedList(new ArrayList());
    private Map<Thread, Void> serviceThreads = Collections.synchronizedMap(new WeakHashMap());
    private TenantConfiguration configuration = null;
    private volatile TenantState state;
    private long tenantId;
    private long allocationContext = 0L;
    private String name;
    private Properties props;
    private long accumulatedMemory = 0L;
    private TenantData tenantData = new TenantData();
    private TenantShutdownHooks tenantShutdownHooks = new TenantShutdownHooks();
    private ReentrantReadWriteLock destroyLock = new ReentrantReadWriteLock();

    public synchronized long getAllocatedMemory() {
        Thread[] threadArray = this.getAttachedThreads();
        int n = threadArray.length;
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = threadArray[i].getId();
        }
        nd.getThreadsAllocatedMemory(lArray, lArray2);
        long l = 0L;
        for (long l2 : lArray2) {
            l += l2;
        }
        return l + this.accumulatedMemory;
    }

    public TenantData getTenantData() {
        return this.tenantData;
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
            Properties properties2 = System.getProperties();
            for (Object k : properties2.keySet()) {
                properties.put(k, properties2.get(k));
            }
        }
        this.props = properties;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String setProperty(String string, String string2) {
        this.checkKey(string);
        return (String)this.props.setProperty(string, string2);
    }

    public String getProperty(String string) {
        this.checkKey(string);
        return this.props.getProperty(string);
    }

    public String clearProperty(String string) {
        this.checkKey(string);
        return (String)this.props.remove(string);
    }

    private void checkKey(String string) {
        if (null == string) {
            throw new NullPointerException("key can't be null");
        }
        if ("".equals(string)) {
            throw new IllegalArgumentException("key can't be empty");
        }
    }

    public void destroy() {
        block9: {
            if (TenantContainer.current() != null) {
                throw new RuntimeException("Should only call destroy() in ROOT tenant");
            }
            this.destroyLock.writeLock().lock();
            try {
                if (this.state == TenantState.STOPPING || this.state == TenantState.DEAD) break block9;
                this.setState(TenantState.STOPPING);
                tenantContainerMap.remove(this.getTenantId());
                this.resourceContainer.attach();
                nd.attach(this);
                try {
                    Runtime.getRuntime().runFinalization();
                }
                finally {
                    nd.attach(null);
                    this.resourceContainer.detach();
                }
                this.tenantShutdownHooks.runHooks();
            }
            catch (Throwable throwable) {
                System.err.println("Exception from TenantContainer.destroy()");
                throwable.printStackTrace();
            }
            finally {
                this.setState(TenantState.DEAD);
                this.cleanUp();
                this.destroyLock.writeLock().unlock();
            }
        }
    }

    private void cleanUp() {
        if (TenantGlobals.isHeapIsolationEnabled()) {
            nd.destroyTenantAllocationContext(this.allocationContext);
        }
        this.resourceContainer.destroyImpl();
        this.spawnedThreads.clear();
        this.attachedThreads.clear();
        this.tenantData.clear();
        this.tenantShutdownHooks = null;
    }

    private TenantContainer(TenantContainer tenantContainer, String string, TenantConfiguration tenantConfiguration) {
        this.tenantId = nextTenantID.getAndIncrement();
        this.resourceContainer = new TenantResourceContainer(tenantContainer == null ? null : tenantContainer.resourceContainer, this, tenantConfiguration.getAllConstraints());
        this.name = string == null ? "Tenant-" + this.getTenantId() : string;
        this.configuration = tenantConfiguration;
        this.setState(TenantState.STARTING);
        this.props = new Properties();
        this.props.putAll(System.getProperties());
        tenantContainerMap.put(this.tenantId, this);
        if (TenantGlobals.isHeapIsolationEnabled()) {
            nd.createTenantAllocationContext(this, tenantConfiguration.getMaxHeap());
        }
    }

    TenantConfiguration getConfiguration() {
        return this.configuration;
    }

    public TenantState getState() {
        return this.state;
    }

    void setState(TenantState tenantState) {
        this.state = tenantState;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public synchronized Thread[] getAttachedThreads() {
        return this.attachedThreads.toArray(new Thread[this.attachedThreads.size()]);
    }

    public static TenantContainer getTenantContainerById(long l) {
        TenantContainer.checkIfTenantIsEnabled();
        return tenantContainerMap.get(l);
    }

    public static TenantContainer create(TenantConfiguration tenantConfiguration) {
        return TenantContainer.create(TenantContainer.current(), tenantConfiguration);
    }

    public static TenantContainer create(TenantContainer tenantContainer, TenantConfiguration tenantConfiguration) {
        TenantContainer.checkIfTenantIsEnabled();
        if (null == tenantConfiguration) {
            throw new IllegalArgumentException("Failed to create tenant, illegal arguments: configuration is null");
        }
        return TenantContainer.create(tenantContainer, null, tenantConfiguration);
    }

    public static TenantContainer create(String string, TenantConfiguration tenantConfiguration) {
        return TenantContainer.create(TenantContainer.current(), string, tenantConfiguration);
    }

    public static TenantContainer create(TenantContainer tenantContainer, String string, TenantConfiguration tenantConfiguration) {
        TenantContainer.checkIfTenantIsEnabled();
        if (null == tenantConfiguration) {
            throw new IllegalArgumentException("Failed to create tenant, illegal arguments: configuration is null");
        }
        TenantContainer tenantContainer2 = new TenantContainer(tenantContainer, string, tenantConfiguration);
        tenantContainerMap.put(tenantContainer2.getTenantId(), tenantContainer2);
        return tenantContainer2;
    }

    public static List<Long> getAllTenantIds() {
        TenantContainer.checkIfTenantIsEnabled();
        if (null == tenantContainerMap) {
            throw new IllegalStateException("TenantContainer class is not initialized !");
        }
        if (tenantContainerMap.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<Long>(tenantContainerMap.keySet());
    }

    public static TenantContainer current() {
        TenantContainer.checkIfTenantIsEnabled();
        AbstractResourceContainer abstractResourceContainer = TenantResourceContainer.current();
        if (TenantResourceContainer.root() == abstractResourceContainer) {
            return null;
        }
        assert (abstractResourceContainer instanceof TenantResourceContainer);
        return ((TenantResourceContainer)abstractResourceContainer).getTenant();
    }

    public long getProcessCpuTime() {
        if (!TenantGlobals.isCpuAccountingEnabled()) {
            throw new IllegalStateException("-XX:+TenantCpuAccounting is not enabled");
        }
        long l = 0L;
        return l;
    }

    public long getOccupiedMemory() {
        if (!TenantGlobals.isHeapIsolationEnabled()) {
            throw new IllegalStateException("-XX:+TenantHeapIsolation is not enabled");
        }
        return nd.getTenantOccupiedMemory(this.allocationContext);
    }

    public void run(Runnable runnable) throws TenantException {
        if (this.getState() == TenantState.DEAD || this.getState() == TenantState.STOPPING) {
            throw new TenantException("Tenant is dead");
        }
        TenantContainer tenantContainer = TenantContainer.current();
        if (tenantContainer == this) {
            runnable.run();
        } else {
            if (tenantContainer != null) {
                throw new TenantException("must be in root container before running into non-root container.");
            }
            this.attach();
            try {
                runnable.run();
            }
            finally {
                this.detach();
            }
        }
    }

    private long getThreadAllocatedMemory() {
        long[] lArray = new long[1];
        nd.getThreadsAllocatedMemory(null, lArray);
        return lArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach() {
        if (this.getState() == TenantState.STARTING) {
            this.setState(TenantState.RUNNING);
        }
        Thread thread = Thread.currentThread();
        long l = this.getThreadAllocatedMemory();
        TenantContainer tenantContainer = this;
        synchronized (tenantContainer) {
            this.attachedThreads.add(thread);
            this.accumulatedMemory -= l;
            this.resourceContainer.attach();
            nd.attach(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detach() {
        Thread thread = Thread.currentThread();
        long l = this.getThreadAllocatedMemory();
        TenantContainer tenantContainer = this;
        synchronized (tenantContainer) {
            nd.attach(null);
            this.resourceContainer.detach();
            this.attachedThreads.remove(thread);
            this.accumulatedMemory += l;
        }
    }

    private static void checkIfTenantIsEnabled() {
        if (!TenantGlobals.isTenantEnabled()) {
            throw new UnsupportedOperationException("The multi-tenant feature is not enabled!");
        }
    }

    private void runThread(Thread thread) throws TenantException {
        if (this.destroyLock.readLock().tryLock()) {
            if (this.getState() != TenantState.STOPPING && this.getState() != TenantState.DEAD) {
                this.spawnedThreads.add(new WeakReference<Thread>(thread));
                this.run(() -> {
                    this.destroyLock.readLock().unlock();
                    thread.run();
                });
            } else {
                this.destroyLock.readLock().unlock();
            }
            if (this.destroyLock.readLock().tryLock()) {
                if (this.getState() != TenantState.STOPPING && this.getState() != TenantState.DEAD) {
                    this.spawnedThreads.removeIf(weakReference -> weakReference.get() == null || weakReference.get() == thread);
                }
                this.destroyLock.readLock().unlock();
            }
        } else if (this.serviceThreads.containsKey(thread)) {
            this.resourceContainer.attach();
            nd.attach(this);
            try {
                thread.run();
            }
            finally {
                nd.attach(null);
                this.resourceContainer.detach();
                this.removeServiceThread(thread);
            }
        }
    }

    private static void initializeTenantContainerClass() {
        tenantContainerMap = Collections.synchronizedMap(new HashMap());
        if (SharedSecrets.getTenantAccess() == null) {
            SharedSecrets.setTenantAccess(new TenantAccess(){

                @Override
                public void registerServiceThread(TenantContainer tenantContainer, Thread thread) {
                    if (tenantContainer != null && thread != null) {
                        tenantContainer.addServiceThread(thread);
                    }
                }
            });
        }
        try {
            Class.forName("com.alibaba.tenant.TenantConfiguration");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public static TenantContainer containerOf(Object object) {
        if (!TenantGlobals.isHeapIsolationEnabled()) {
            throw new UnsupportedOperationException("containerOf() only works with -XX:+TenantHeapIsolation");
        }
        return object != null ? nd.containerOf(object) : null;
    }

    public <K, T> T getFieldValue(K k, String string, Supplier<T> supplier) {
        return this.tenantData.getFieldValue(k, string, supplier);
    }

    public <K, T> T getFieldValue(K k, String string) {
        return (T)this.getFieldValue(k, string, () -> null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T primitiveRunInRoot(Supplier<T> supplier) {
        if (null == TenantContainer.current()) {
            return supplier.get();
        }
        TenantContainer tenantContainer = TenantContainer.current();
        tenantContainer.resourceContainer.detach();
        nd.attach(null);
        try {
            T t;
            T t2 = t = supplier.get();
            return t2;
        }
        finally {
            nd.attach(tenantContainer);
            tenantContainer.resourceContainer.attach();
        }
    }

    public static void primitiveRunInRoot(Runnable runnable) {
        TenantContainer.primitiveRunInRoot(() -> {
            runnable.run();
            return null;
        });
    }

    public void addShutdownHook(Thread thread) {
        this.addServiceThread(thread);
        this.tenantShutdownHooks.add(thread);
    }

    public boolean removeShutdownHook(Thread thread) {
        this.removeServiceThread(thread);
        return this.tenantShutdownHooks.remove(thread);
    }

    private void addServiceThread(Thread thread) {
        if (thread != null) {
            this.serviceThreads.put(thread, null);
        }
    }

    private void removeServiceThread(Thread thread) {
        this.serviceThreads.remove(thread);
    }

    public void update(TenantConfiguration tenantConfiguration) {
        for (Constraint constraint : tenantConfiguration.getAllConstraints()) {
            this.updateConstraint(constraint);
        }
    }

    void updateConstraint(Constraint constraint) {
        this.resourceContainer.updateConstraint(constraint);
        this.getConfiguration().setConstraint(constraint);
    }

    public ResourceContainer getResourceContainer() {
        return this.resourceContainer;
    }
}

