/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tenant;

import com.alibaba.rcm.Constraint;
import com.alibaba.rcm.ResourceType;
import com.alibaba.tenant.JGroup;
import com.alibaba.tenant.JGroupConstraint;
import com.alibaba.tenant.NativeDispatcher;
import java.util.Arrays;
import java.util.stream.Collectors;

class TenantResourceType
extends ResourceType {
    static final ResourceType CPU_SHARES = new TenantResourceType("CPU_SHARE", true){

        @Override
        protected void validate(long ... lArray) throws IllegalArgumentException {
            if (lArray == null || lArray.length != 1 || lArray[0] <= 0L) {
                throw new IllegalArgumentException("Bad CPU_SHARE constraint:" + lArray[0]);
            }
        }

        @Override
        public Constraint newConstraint(long ... lArray) {
            this.validate(lArray);
            return new JGroupConstraint(this, lArray){

                @Override
                void sync(JGroup jGroup) {
                    if (NativeDispatcher.IS_CPU_SHARES_ENABLED) {
                        jGroup.setValue("cpu.shares", Integer.toString((int)this.getValues()[0]));
                    }
                }
            };
        }
    };
    static final ResourceType CPUSET_CPUS = new TenantResourceType("CPUSET_CPUS", true){

        @Override
        protected void validate(long ... lArray) throws IllegalArgumentException {
            if (lArray == null || lArray.length > Runtime.getRuntime().availableProcessors()) {
                throw new IllegalArgumentException("Invalid number of cpuset.cpus:" + (lArray == null ? 0 : lArray.length));
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (long l : lArray) {
                if (l >= 0L && l < (long)Runtime.getRuntime().availableProcessors()) continue;
                stringBuilder.append(l).append(",");
            }
            Object object = stringBuilder.toString();
            if (!((String)object).isEmpty()) {
                throw new IllegalArgumentException("Invalid cpuset cores: " + (String)object);
            }
        }

        @Override
        public Constraint newConstraint(long ... lArray) {
            this.validate(lArray);
            return new JGroupConstraint(this, lArray){

                @Override
                void sync(JGroup jGroup) {
                    if (NativeDispatcher.IS_CPUSET_ENABLED) {
                        String string = Arrays.stream(this.getValues()).mapToObj(l -> Long.toString(l)).collect(Collectors.joining(","));
                        jGroup.setValue("cpuset.cpus", string);
                    }
                }
            };
        }
    };
    static final ResourceType CPU_CFS = new TenantResourceType("CPU_CFS", true){

        @Override
        protected void validate(long ... lArray) throws IllegalArgumentException {
            if (lArray == null || lArray.length != 2) {
                throw new IllegalArgumentException("CPU_CFS requires constraints period and quota at the same time");
            }
            long l = lArray[0];
            long l2 = lArray[1];
            if (l < 1000L || l > 1000000L) {
                throw new IllegalArgumentException("Invalid cpu_cfs.period value:" + l + ", expected range [1_000, 1_000_000");
            }
            if (l2 < 1000L && l2 != -1L) {
                throw new IllegalArgumentException("Invalid cpu_cfs.quota value:" + l2 + ", should >= 1_000 or be unlimited (-1)");
            }
        }

        @Override
        public Constraint newConstraint(final long ... lArray) {
            this.validate(lArray);
            return new JGroupConstraint(this, lArray){

                @Override
                void sync(JGroup jGroup) {
                    if (NativeDispatcher.IS_CPU_CFS_ENABLED) {
                        jGroup.setValue("cpu.cfs_period_us", Long.toString(lArray[0]));
                        jGroup.setValue("cpu.cfs_quota_us", Long.toString(lArray[1]));
                    }
                }
            };
        }
    };
    static final ResourceType SOCKET = new TenantResourceType("SOCKET", false){

        @Override
        protected void validate(long ... lArray) throws IllegalArgumentException {
            if (lArray == null || lArray.length != 1 || lArray[0] <= 0L) {
                throw new IllegalArgumentException("Bad CPU_SHARE constraint:" + lArray[0]);
            }
        }
    };
    private boolean isJGroupResource;

    private TenantResourceType(String string, boolean bl) {
        super(string);
        this.isJGroupResource = bl;
    }

    boolean isJGroupResource() {
        return this.isJGroupResource;
    }
}

