/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.util;

import com.alibaba.cds.CDSDumperHelper;
import com.alibaba.util.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class QuickStart {
    private static final String CONFIG_NAME = "quickstart.properties";
    private static final String SERVERLESS_ADAPTER_NAME = "ServerlessAdapter";
    private static final String CDSDUMPER_NAME = "CDSDumper";
    private static String serverlessAdapter;
    private static QuickStartRole role;
    private static final List<Runnable> dumpHooks;
    private static boolean verbose;
    protected static String cachePath;
    protected static String[] vmOptionsInProfileStage;
    protected static String classPathInProfileStage;
    private static boolean notifyCompleted;

    public static void setServerlessAdapter(String string) {
        serverlessAdapter = string;
    }

    public static String getServerlessAdapter() {
        return serverlessAdapter;
    }

    private static native void registerNatives();

    private static void loadQuickStartConfig() {
        Properties properties = AccessController.doPrivileged(System::getProperties);
        Path path = Paths.get(Utils.getJDKHome(), "lib", CONFIG_NAME);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(path.toFile()));){
            properties.load(bufferedInputStream);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        CDSDumperHelper.setCdsDumper(properties.getProperty(CDSDUMPER_NAME));
        QuickStart.setServerlessAdapter(properties.getProperty(SERVERLESS_ADAPTER_NAME));
    }

    public static boolean isVerbose() {
        return verbose;
    }

    private static void initialize(int n, String string, boolean bl, String[] stringArray, String string2) {
        role = QuickStartRole.getRoleByCode(n);
        cachePath = string;
        verbose = bl;
        vmOptionsInProfileStage = stringArray;
        classPathInProfileStage = string2;
        if (role == QuickStartRole.TRACER || role == QuickStartRole.PROFILER) {
            Runtime.getRuntime().addShutdownHook(new Thread(QuickStart::notifyDump));
        }
    }

    public static boolean isNormal() {
        return role == QuickStartRole.NORMAL;
    }

    public static boolean isTracer() {
        return role == QuickStartRole.TRACER;
    }

    public static boolean isReplayer() {
        return role == QuickStartRole.REPLAYER;
    }

    public static boolean isDumper() {
        return role == QuickStartRole.DUMPER;
    }

    public static String[] getVmOptionsInProfileStage() {
        return vmOptionsInProfileStage;
    }

    public static String getClassPathInProfileStage() {
        return classPathInProfileStage;
    }

    public static String cachePath() {
        return cachePath;
    }

    public static synchronized void addDumpHook(Runnable runnable) {
        if (notifyCompleted) {
            return;
        }
        dumpHooks.add(runnable);
    }

    public static synchronized void notifyDump(String string) {
        QuickStart.notifyDump();
        if (role == QuickStartRole.PROFILER && string != null && !"".equals(string)) {
            QuickStart.doCopy(new File(QuickStart.cachePath()), QuickStart.checkDestDir(string));
        }
    }

    private static void doCopy(File file2, File file3) {
        try {
            if (file2.getCanonicalPath().equals(file3.getCanonicalPath())) {
                return;
            }
            File[] fileArray = file2.listFiles(file -> file.isFile());
            if (fileArray != null) {
                for (File file4 : fileArray) {
                    Files.copy(file4.toPath(), file3.toPath().resolve(file4.getName()), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static File checkDestDir(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new RuntimeException(string + " is not a directory.");
            }
        } else if (!file.mkdirs()) {
            throw new RuntimeException("Create directory " + string + " failed.");
        }
        return file;
    }

    public static synchronized void notifyDump() {
        if (notifyCompleted) {
            return;
        }
        for (Runnable runnable : dumpHooks) {
            runnable.run();
        }
        QuickStart.notifyDump0();
        notifyCompleted = true;
    }

    private static native void notifyDump0();

    static {
        QuickStart.registerNatives();
        QuickStart.loadQuickStartConfig();
        role = QuickStartRole.NORMAL;
        dumpHooks = new ArrayList<Runnable>();
        verbose = false;
        notifyCompleted = false;
    }

    public static enum QuickStartRole {
        NORMAL(0),
        TRACER(1),
        REPLAYER(2),
        PROFILER(3),
        DUMPER(4);

        int code;

        private QuickStartRole(int n2) {
            this.code = n2;
        }

        public static QuickStartRole getRoleByCode(int n) {
            for (QuickStartRole quickStartRole : QuickStartRole.values()) {
                if (quickStartRole.code != n) continue;
                return quickStartRole;
            }
            return null;
        }
    }
}

