/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.wisp.engine.WispCarrier;
import com.alibaba.wisp.engine.WispConfiguration;
import com.alibaba.wisp.engine.WispEngine;
import com.alibaba.wisp.engine.WispScheduler;
import com.alibaba.wisp.engine.WispTask;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.SharedSecrets;
import sun.nio.ch.IOEventAccess;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;

class WispEventPump {
    private static final int LOW_FD_BOUND = 10240;
    private static final int MAX_EVENTS_TO_POLL = 512;
    private static final IOEventAccess IOEA;
    private final int epfd;
    private final int pipe0;
    private final int pipe1;
    private final long epollArray;
    private final WispTask[] fd2ReadTaskLow = new WispTask[10240];
    private final ConcurrentHashMap<Integer, WispTask> fd2ReadTaskHigh = new ConcurrentHashMap();
    private final WispTask[] fd2WriteTaskLow = new WispTask[10240];
    private final ConcurrentHashMap<Integer, WispTask> fd2WriteTaskHigh = new ConcurrentHashMap();
    private volatile int wakeupCount;
    volatile WispScheduler.Worker owner;
    private static final AtomicReferenceFieldUpdater<WispEventPump, WispScheduler.Worker> OWNER_UPDATER;
    private static final AtomicIntegerFieldUpdater<WispEventPump> WAKEUP_UPDATER;

    private WispEventPump() {
        try {
            this.epfd = IOEA.eventCreate();
            int[] nArray = new int[2];
            IOEA.socketpair(nArray);
            this.pipe0 = nArray[0];
            this.pipe1 = nArray[1];
            if (IOEA.eventCtl(this.epfd, IOEA.eventCtlAdd(), this.pipe0, Net.POLLIN) != 0) {
                throw new IOException("epoll_ctl fail");
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        this.epollArray = IOEA.allocatePollArray(512);
    }

    private static boolean isNativeReadEvent(int n) throws IllegalArgumentException {
        int n2 = n & (Net.POLLCONN | Net.POLLIN | Net.POLLOUT);
        assert (Integer.bitCount(n2) == 1);
        return (n & Net.POLLIN) != 0;
    }

    private WispTask[] getFd2TaskLow(int n) {
        return WispEventPump.isNativeReadEvent(n) ? this.fd2ReadTaskLow : this.fd2WriteTaskLow;
    }

    private ConcurrentHashMap<Integer, WispTask> getFd2TaskHigh(int n) {
        return WispEventPump.isNativeReadEvent(n) ? this.fd2ReadTaskHigh : this.fd2WriteTaskHigh;
    }

    private boolean sanityCheck(int n, WispTask wispTask, int n2) {
        WispTask wispTask2 = n < 10240 ? this.getFd2TaskLow(n2)[n] : this.getFd2TaskHigh(n2).get(n);
        return wispTask2 == null || wispTask2 == wispTask || wispTask2.ch == null || ((SelChImpl)((Object)wispTask2.ch)).getFDVal() != n;
    }

    private void recordTaskByFD(int n, WispTask wispTask, int n2) {
        assert (this.sanityCheck(n, wispTask, n2));
        if (n < 10240) {
            this.getFd2TaskLow((int)n2)[n] = wispTask;
        } else {
            this.getFd2TaskHigh(n2).put(n, wispTask);
        }
    }

    private WispTask removeTaskByFD(int n, int n2) {
        WispTask wispTask;
        if (n < 10240) {
            WispTask[] wispTaskArray = this.getFd2TaskLow(n2);
            wispTask = wispTaskArray[n];
            wispTaskArray[n] = null;
        } else {
            wispTask = this.getFd2TaskHigh(n2).remove(n);
        }
        return wispTask;
    }

    private static int toNativeEvent(int n) {
        int n2 = 0;
        if ((n & 0x11) != 0) {
            n2 |= Net.POLLIN;
        }
        if ((n & 4) != 0) {
            n2 |= Net.POLLOUT;
        }
        if ((n & 8) != 0) {
            n2 |= Net.POLLCONN;
        }
        return n2;
    }

    private void registerEvent(WispTask wispTask, int n, int n2) throws IOException {
        int n3 = WispEventPump.toNativeEvent(n2);
        n3 |= Net.POLLHUP;
        this.recordTaskByFD(n, wispTask, n3 |= IOEA.eventOneShot());
        wispTask.setRegisterEventTime();
        int n4 = IOEA.eventCtl(this.epfd, IOEA.eventCtlMod(), n, n3);
        if (n4 != 0 && (n4 != IOEA.noEvent() || (n4 = IOEA.eventCtl(this.epfd, IOEA.eventCtlAdd(), n, n3)) != 0)) {
            this.removeTaskByFD(n, n3);
            wispTask.resetRegisterEventTime();
            throw new IOException("epoll_ctl " + n4);
        }
    }

    private int epollWaitForWisp(int n, long l, int n2, long l2, AtomicReference<Object> atomicReference, Object object) throws IOException {
        assert (l != 0L);
        WispTask wispTask = WispCarrier.current().current;
        if (!WispEngine.runningAsCoroutine(wispTask.getThreadWrapper())) {
            return IOEA.eventWait(n, l, n2, (int)l2);
        }
        if (WispConfiguration.MONOLITHIC_POLL) {
            if (l2 == 0L) {
                return 0;
            }
        } else {
            int n3 = IOEA.eventWait(n, l, n2, 0);
            if (l2 == 0L || n3 > 0) {
                return n3;
            }
        }
        assert (l2 != 0L);
        if (WispConfiguration.USE_DIRECT_SELECTOR_WAKEUP && (atomicReference.get() == object || atomicReference.get() != null || !atomicReference.compareAndSet(null, wispTask))) {
            assert (atomicReference.get() == object);
            return 0;
        }
        if (WispConfiguration.MONOLITHIC_POLL) {
            wispTask.epollArraySize = n2;
            wispTask.setEpollEventNum(0);
            wispTask.setEpollArray(l);
        }
        this.registerEvent(wispTask, n, 1);
        WispTask.jdkPark(TimeUnit.MILLISECONDS.toNanos(l2));
        if (WispConfiguration.USE_DIRECT_SELECTOR_WAKEUP && (atomicReference.get() != wispTask || !atomicReference.compareAndSet(wispTask, null))) assert (atomicReference.get() == object);
        if (WispConfiguration.MONOLITHIC_POLL) {
            wispTask.setEpollArray(0L);
            return wispTask.getEpollEventNum();
        }
        return IOEA.eventWait(n, l, n2, 0);
    }

    private void doMonolithicPoll(int n, WispTask wispTask, long l) throws IOException {
        assert (WispConfiguration.MONOLITHIC_POLL);
        wispTask.setEpollEventNum(IOEA.eventWait(n, l, wispTask.epollArraySize, 0));
    }

    private static void interruptEpoll(AtomicReference<Object> atomicReference, Object object, int n) {
        block6: {
            Object object2;
            assert (WispConfiguration.USE_DIRECT_SELECTOR_WAKEUP);
            while (true) {
                if ((object2 = atomicReference.get()) == object || object2 == null && atomicReference.compareAndSet(null, object)) {
                    if (WispConfiguration.ALL_THREAD_AS_WISP) break block6;
                    try {
                        IOEA.interrupt(n);
                        break block6;
                    }
                    catch (IOException iOException) {
                        throw new UncheckedIOException(iOException);
                    }
                }
                if (object2 == null) continue;
                assert (object2 instanceof WispTask);
                if (atomicReference.compareAndSet(object2, object)) break;
            }
            ((WispTask)object2).jdkUnpark();
        }
    }

    boolean pollAndDispatchEvents(long l) {
        boolean bl = false;
        try {
            int n = IOEA.eventWait(this.epfd, this.epollArray, 512, (int)l);
            while (n-- > 0) {
                long l2 = IOEA.getEvent(this.epollArray, n);
                int n2 = IOEA.getDescriptor(l2);
                if (n2 == this.pipe0) {
                    bl = true;
                    if (WAKEUP_UPDATER.decrementAndGet(this) != 0) continue;
                    IOEA.drain(this.pipe0);
                    continue;
                }
                int n3 = IOEA.getEvents(l2);
                if ((n3 & Net.POLLIN) != 0) {
                    this.processEvent(n2, true);
                }
                if ((n3 & Net.POLLCONN) == 0 && (n3 & Net.POLLOUT) == 0) continue;
                this.processEvent(n2, false);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    private void processEvent(int n, boolean bl) throws IOException {
        WispTask wispTask = this.removeTaskByFD(n, bl ? Net.POLLIN : Net.POLLOUT);
        if (wispTask != null) {
            long l = wispTask.getEpollArray();
            if (bl && l != 0L) {
                this.doMonolithicPoll(n, wispTask, l);
            } else {
                wispTask.countWaitSocketIOTime();
            }
            wispTask.jdkUnpark();
        }
    }

    void wakeup() {
        if (WAKEUP_UPDATER.getAndIncrement(this) == 0) {
            try {
                IOEA.interrupt(this.pipe1);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
    }

    boolean tryAcquire(WispScheduler.Worker worker) {
        assert (WispConfiguration.CARRIER_AS_POLLER);
        return this.owner == null && OWNER_UPDATER.compareAndSet(this, null, worker);
    }

    void release(WispScheduler.Worker worker) {
        assert (this.owner == worker);
        OWNER_UPDATER.lazySet(this, null);
    }

    static {
        IOUtil.load();
        IOEA = SharedSecrets.getIOEventAccess();
        OWNER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(WispEventPump.class, WispScheduler.Worker.class, "owner");
        WAKEUP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WispEventPump.class, "wakeupCount");
    }

    static enum Pool {
        INSTANCE;

        private final int mask;
        private final WispEventPump[] pumps;

        private Pool() {
            int n2 = Math.max(1, WispConfiguration.WORKER_COUNT / WispConfiguration.POLLER_SHARDING_SIZE);
            int n3 = n2 = (n2 & n2 - 1) == 0 ? n2 : Integer.highestOneBit(n2) * 2;
            if (WispConfiguration.SEPARATE_IO_POLLER) {
                n2 = Math.max(2, n2);
            }
            this.mask = n2 - 1;
            this.pumps = new WispEventPump[n2];
            for (int i = 0; i < this.pumps.length; ++i) {
                this.pumps[i] = new WispEventPump();
            }
        }

        void startPollerThreads() {
            int n = 0;
            for (final WispEventPump wispEventPump : this.pumps) {
                Thread thread = new Thread(WispEngine.DAEMON_THREAD_GROUP, new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            wispEventPump.pollAndDispatchEvents(-1L);
                        }
                    }
                }, "Wisp-Poller-" + n++);
                thread.setDaemon(true);
                thread.start();
            }
        }

        private static int hash(int n) {
            return n * -1640531535;
        }

        private WispEventPump pumpFromFd(int n, boolean bl) {
            int n2 = WispConfiguration.SEPARATE_IO_POLLER && !bl ? 0 : 1;
            return this.pumps[Pool.hash(n) + n2 & this.mask];
        }

        void registerEvent(WispTask wispTask, SelectableChannel selectableChannel, int n) throws IOException {
            if (selectableChannel != null && selectableChannel.isOpen()) {
                int n2 = ((SelChImpl)((Object)selectableChannel)).getFDVal();
                this.pumpFromFd(n2, WispEventPump.isNativeReadEvent(WispEventPump.toNativeEvent(n))).registerEvent(wispTask, n2, n);
            }
        }

        int epollWaitForWisp(int n, long l, int n2, long l2, AtomicReference<Object> atomicReference, Object object) throws IOException {
            return this.pumpFromFd(n, true).epollWaitForWisp(n, l, n2, l2, atomicReference, object);
        }

        void interruptEpoll(AtomicReference<Object> atomicReference, Object object, int n) {
            WispEventPump.interruptEpoll(atomicReference, object, n);
        }

        WispEventPump getPump(int n) {
            return this.pumps[n & this.mask];
        }
    }
}

