/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.wisp.engine.WispConfiguration;
import com.alibaba.wisp.engine.WispCounter;
import com.alibaba.wisp.engine.WispEngine;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import sun.misc.VM;

enum WispPerfCounterMonitor {
    INSTANCE;

    private boolean fileHandleEnable = false;
    private Map<Long, WispPerfCounter> managedEngineCounters;
    private Logger wispLog;
    private final SimpleDateFormat localDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private WispPerfCounterMonitor() {
        if (WispConfiguration.WISP_PROFILE) {
            this.managedEngineCounters = new ConcurrentHashMap<Long, WispPerfCounter>(100);
        }
        if (WispConfiguration.WISP_PROFILE_LOG_ENABLED) {
            String string2 = WispConfiguration.WISP_PROFILE_LOG_PATH;
            this.wispLog = Logger.getLogger(WispPerfCounterMonitor.class.getName());
            try {
                FileHandler fileHandler = new FileHandler(string2 == null ? "wisplog%g.log" : string2 + File.separator + "wisplog%g.log", 12800000, 4, true);
                fileHandler.setLevel(Level.INFO);
                fileHandler.setFormatter(new Formatter(){

                    @Override
                    public String format(LogRecord logRecord) {
                        return logRecord.getMessage() + "\n";
                    }
                });
                this.wispLog.setUseParentHandlers(false);
                this.wispLog.addHandler(fileHandler);
                this.fileHandleEnable = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    void startDaemon() {
        Thread thread = new Thread(WispEngine.DAEMON_THREAD_GROUP, this::perfCounterLoop, "Wisp-Monitor");
        thread.setDaemon(true);
        thread.start();
    }

    void register(WispCounter wispCounter) {
        if (WispConfiguration.WISP_PROFILE && VM.isBooted()) {
            WispPerfCounter wispPerfCounter = new WispPerfCounter(wispCounter);
            this.managedEngineCounters.put(wispCounter.carrier.getId(), wispPerfCounter);
        }
    }

    void deRegister(WispCounter wispCounter) {
        if (WispConfiguration.WISP_PROFILE) {
            this.managedEngineCounters.remove(wispCounter.carrier.getId());
        }
    }

    WispCounter getWispCounter(long l) {
        WispPerfCounter wispPerfCounter = WispEngine.runInCritical(() -> this.managedEngineCounters.get(l));
        if (wispPerfCounter == null) {
            return null;
        }
        wispPerfCounter.storeCurrentWispCounter();
        return wispPerfCounter.prevCounterValue;
    }

    private void perfCounterLoop() {
        while (true) {
            try {
                Thread.sleep(WispConfiguration.WISP_PROFILE_LOG_INTERVAL_MS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.dumpCounter();
        }
    }

    private void appendLogString(StringBuilder stringBuilder, String string, String string2, int n, long l) {
        stringBuilder.append(string).append("\t").append(string2).append("\t\t").append("worker").append(n).append("\t\t").append(l).append("\n");
    }

    private void dumpCounter() {
        if (!this.fileHandleEnable) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l = System.currentTimeMillis();
        String string = this.localDateFormat.format(new Date(l));
        int n = 0;
        for (Map.Entry<Long, WispPerfCounter> entry : this.managedEngineCounters.entrySet()) {
            WispPerfCounter wispPerfCounter = entry.getValue();
            this.appendLogString(stringBuilder, string, "completedTaskCount", n, wispPerfCounter.getCompletedTaskCount());
            this.appendLogString(stringBuilder, string, "unparkFromJvmCount", n, wispPerfCounter.getUnparkFromJvmCount());
            this.appendLogString(stringBuilder, string, "averageEnqueueTime", n, wispPerfCounter.getAverageEnqueueTime());
            this.appendLogString(stringBuilder, string, "averageExecutionTime", n, wispPerfCounter.getAverageExecutionTime());
            this.appendLogString(stringBuilder, string, "averageWaitSocketIOTime", n, wispPerfCounter.getAverageWaitSocketIOTime());
            this.appendLogString(stringBuilder, string, "averageBlockingTime", n, wispPerfCounter.getAverageBlockingTime());
            wispPerfCounter.storeCurrentWispCounter();
            ++n;
        }
        this.wispLog.info(stringBuilder.toString());
    }

    private class WispPerfCounter {
        WispCounter counter;
        WispCounter prevCounterValue;

        long getCompletedTaskCount() {
            return this.counter.getCompletedTaskCount() - this.prevCounterValue.getCompletedTaskCount();
        }

        long getUnparkFromJvmCount() {
            return this.counter.getUnparkFromJvmCount() - this.prevCounterValue.getUnparkFromJvmCount();
        }

        long getAverageTime(Function<WispCounter, Long> function, Function<WispCounter, Long> function2) {
            long l = function2.apply(this.counter) - function2.apply(this.prevCounterValue);
            if (l == 0L) {
                return 0L;
            }
            long l2 = function.apply(this.counter) - function.apply(this.prevCounterValue);
            return l2 / l;
        }

        long getAverageEnqueueTime() {
            return this.getAverageTime(WispCounter::getTotalEnqueueTime, WispCounter::getEnqueueCount);
        }

        long getAverageExecutionTime() {
            return this.getAverageTime(WispCounter::getTotalExecutionTime, WispCounter::getExecutionCount);
        }

        long getAverageWaitSocketIOTime() {
            return this.getAverageTime(WispCounter::getTotalWaitSocketIOTime, WispCounter::getWaitSocketIOCount);
        }

        long getAverageBlockingTime() {
            return this.getAverageTime(WispCounter::getTotalBlockingTime, WispCounter::getUnparkCount);
        }

        void storeCurrentWispCounter() {
            if (this.counter == null) {
                return;
            }
            this.prevCounterValue.assign(this.counter);
            this.counter.resetMaxValue();
        }

        WispPerfCounter(WispCounter wispCounter) {
            this.counter = wispCounter;
            this.prevCounterValue = new WispCounter();
            this.prevCounterValue.assign(wispCounter);
        }
    }
}

