/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.bmp;

import com.sun.imageio.plugins.bmp.BMPConstants;
import com.sun.imageio.plugins.bmp.BMPMetadata;
import com.sun.imageio.plugins.common.I18N;
import com.sun.imageio.plugins.common.ImageUtil;
import com.sun.imageio.plugins.common.ReaderUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOParam;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class BMPImageReader
extends ImageReader
implements BMPConstants {
    private static final int VERSION_2_1_BIT = 0;
    private static final int VERSION_2_4_BIT = 1;
    private static final int VERSION_2_8_BIT = 2;
    private static final int VERSION_2_24_BIT = 3;
    private static final int VERSION_3_1_BIT = 4;
    private static final int VERSION_3_4_BIT = 5;
    private static final int VERSION_3_8_BIT = 6;
    private static final int VERSION_3_24_BIT = 7;
    private static final int VERSION_3_NT_16_BIT = 8;
    private static final int VERSION_3_NT_32_BIT = 9;
    private static final int VERSION_4_1_BIT = 10;
    private static final int VERSION_4_4_BIT = 11;
    private static final int VERSION_4_8_BIT = 12;
    private static final int VERSION_4_16_BIT = 13;
    private static final int VERSION_4_24_BIT = 14;
    private static final int VERSION_4_32_BIT = 15;
    private static final int VERSION_3_XP_EMBEDDED = 16;
    private static final int VERSION_4_XP_EMBEDDED = 17;
    private static final int VERSION_5_XP_EMBEDDED = 18;
    private long bitmapFileSize;
    private long bitmapOffset;
    private long compression;
    private long imageSize;
    private byte[] palette;
    private int imageType;
    private int numBands;
    private boolean isBottomUp;
    private int bitsPerPixel;
    private int redMask;
    private int greenMask;
    private int blueMask;
    private int alphaMask;
    private SampleModel sampleModel;
    private SampleModel originalSampleModel;
    private ColorModel colorModel;
    private ColorModel originalColorModel;
    private ImageInputStream iis = null;
    private boolean gotHeader = false;
    private int width;
    private int height;
    private Rectangle destinationRegion;
    private Rectangle sourceRegion;
    private BMPMetadata metadata;
    private BufferedImage bi;
    private boolean noTransform = true;
    private boolean seleBand = false;
    private int scaleX;
    private int scaleY;
    private int[] sourceBands;
    private int[] destBands;
    private static Boolean isLinkedProfileAllowed = null;

    public BMPImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.iis = (ImageInputStream)object;
        if (this.iis != null) {
            this.iis.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        this.resetHeaderInfo();
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException(I18N.getString("GetNumImages0"));
        }
        if (this.seekForwardOnly && bl) {
            throw new IllegalStateException(I18N.getString("GetNumImages1"));
        }
        return 1;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        try {
            this.readHeader();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IIOException(I18N.getString("BMPImageReader6"), illegalArgumentException);
        }
        return this.width;
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        try {
            this.readHeader();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IIOException(I18N.getString("BMPImageReader6"), illegalArgumentException);
        }
        return this.height;
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(I18N.getString("BMPImageReader0"));
        }
    }

    protected void readHeader() throws IOException, IllegalArgumentException {
        long l;
        long l2;
        int n;
        int n2;
        block84: {
            block86: {
                block85: {
                    block83: {
                        if (this.gotHeader) {
                            return;
                        }
                        if (this.iis == null) {
                            throw new IllegalStateException("Input source not set!");
                        }
                        n2 = 0;
                        n = 0;
                        this.metadata = new BMPMetadata();
                        this.iis.mark();
                        byte[] byArray = new byte[2];
                        this.iis.read(byArray);
                        if (byArray[0] != 66 || byArray[1] != 77) {
                            throw new IllegalArgumentException(I18N.getString("BMPImageReader1"));
                        }
                        this.bitmapFileSize = this.iis.readUnsignedInt();
                        this.iis.skipBytes(4);
                        this.bitmapOffset = this.iis.readUnsignedInt();
                        l2 = this.iis.readUnsignedInt();
                        if (l2 == 12L) {
                            this.width = this.iis.readShort();
                            this.height = this.iis.readShort();
                        } else {
                            this.width = this.iis.readInt();
                            this.height = this.iis.readInt();
                        }
                        this.metadata.width = this.width;
                        this.metadata.height = this.height;
                        int n3 = this.iis.readUnsignedShort();
                        this.bitsPerPixel = this.iis.readUnsignedShort();
                        this.metadata.bitsPerPixel = (short)this.bitsPerPixel;
                        this.numBands = 3;
                        if (l2 != 12L) break block83;
                        this.metadata.bmpVersion = "BMP v. 2.x";
                        if (this.bitsPerPixel == 1) {
                            this.imageType = 0;
                        } else if (this.bitsPerPixel == 4) {
                            this.imageType = 1;
                        } else if (this.bitsPerPixel == 8) {
                            this.imageType = 2;
                        } else if (this.bitsPerPixel == 24) {
                            this.imageType = 3;
                        }
                        int n4 = (int)((this.bitmapOffset - 14L - l2) / 3L);
                        int n5 = n4 * 3;
                        this.palette = new byte[n5];
                        this.iis.readFully(this.palette, 0, n5);
                        this.metadata.palette = this.palette;
                        this.metadata.paletteSize = n4;
                        break block84;
                    }
                    this.compression = this.iis.readUnsignedInt();
                    this.imageSize = this.iis.readUnsignedInt();
                    long l3 = this.iis.readInt();
                    long l4 = this.iis.readInt();
                    long l5 = this.iis.readUnsignedInt();
                    long l6 = this.iis.readUnsignedInt();
                    this.metadata.compression = (int)this.compression;
                    this.metadata.xPixelsPerMeter = (int)l3;
                    this.metadata.yPixelsPerMeter = (int)l4;
                    this.metadata.colorsUsed = (int)l5;
                    this.metadata.colorsImportant = (int)l6;
                    if (l2 != 40L) break block85;
                    switch ((int)this.compression) {
                        case 4: 
                        case 5: {
                            this.metadata.bmpVersion = "BMP v. 3.x";
                            this.imageType = 16;
                            break block84;
                        }
                        case 0: 
                        case 1: 
                        case 2: {
                            if (this.bitmapOffset < l2 + 14L) {
                                throw new IIOException(I18N.getString("BMPImageReader7"));
                            }
                            int n6 = (int)((this.bitmapOffset - 14L - l2) / 4L);
                            int n7 = n6 * 4;
                            this.palette = new byte[n7];
                            this.iis.readFully(this.palette, 0, n7);
                            this.metadata.palette = this.palette;
                            this.metadata.paletteSize = n6;
                            if (this.bitsPerPixel == 1) {
                                this.imageType = 4;
                            } else if (this.bitsPerPixel == 4) {
                                this.imageType = 5;
                            } else if (this.bitsPerPixel == 8) {
                                this.imageType = 6;
                            } else if (this.bitsPerPixel == 24) {
                                this.imageType = 7;
                            } else if (this.bitsPerPixel == 16) {
                                this.imageType = 8;
                                this.redMask = 31744;
                                this.greenMask = 992;
                                this.blueMask = 31;
                                this.metadata.redMask = this.redMask;
                                this.metadata.greenMask = this.greenMask;
                                this.metadata.blueMask = this.blueMask;
                            } else if (this.bitsPerPixel == 32) {
                                this.imageType = 9;
                                this.redMask = 0xFF0000;
                                this.greenMask = 65280;
                                this.blueMask = 255;
                                this.metadata.redMask = this.redMask;
                                this.metadata.greenMask = this.greenMask;
                                this.metadata.blueMask = this.blueMask;
                            }
                            this.metadata.bmpVersion = "BMP v. 3.x";
                            break block84;
                        }
                        case 3: {
                            int n7;
                            if (this.bitsPerPixel == 16) {
                                this.imageType = 8;
                            } else if (this.bitsPerPixel == 32) {
                                this.imageType = 9;
                            }
                            this.redMask = (int)this.iis.readUnsignedInt();
                            this.greenMask = (int)this.iis.readUnsignedInt();
                            this.blueMask = (int)this.iis.readUnsignedInt();
                            this.metadata.redMask = this.redMask;
                            this.metadata.greenMask = this.greenMask;
                            this.metadata.blueMask = this.blueMask;
                            if (l5 != 0L) {
                                n7 = (int)l5 * 4;
                                this.palette = new byte[n7];
                                this.iis.readFully(this.palette, 0, n7);
                                this.metadata.palette = this.palette;
                                this.metadata.paletteSize = (int)l5;
                            }
                            this.metadata.bmpVersion = "BMP v. 3.x NT";
                            break block84;
                        }
                        default: {
                            throw new IIOException(I18N.getString("BMPImageReader2"));
                        }
                    }
                }
                if (l2 != 108L && l2 != 124L) break block86;
                if (l2 == 108L) {
                    this.metadata.bmpVersion = "BMP v. 4.x";
                } else if (l2 == 124L) {
                    this.metadata.bmpVersion = "BMP v. 5.x";
                }
                this.redMask = (int)this.iis.readUnsignedInt();
                this.greenMask = (int)this.iis.readUnsignedInt();
                this.blueMask = (int)this.iis.readUnsignedInt();
                this.alphaMask = (int)this.iis.readUnsignedInt();
                long l7 = this.iis.readUnsignedInt();
                int n8 = this.iis.readInt();
                int n9 = this.iis.readInt();
                int n10 = this.iis.readInt();
                int n11 = this.iis.readInt();
                int n12 = this.iis.readInt();
                int n13 = this.iis.readInt();
                int n14 = this.iis.readInt();
                int n15 = this.iis.readInt();
                int n16 = this.iis.readInt();
                long l8 = this.iis.readUnsignedInt();
                long l9 = this.iis.readUnsignedInt();
                long l10 = this.iis.readUnsignedInt();
                if (l2 == 124L) {
                    this.metadata.intent = this.iis.readInt();
                    n2 = this.iis.readInt();
                    n = this.iis.readInt();
                    this.iis.skipBytes(4);
                }
                this.metadata.colorSpace = (int)l7;
                if (l7 == 0L) {
                    this.metadata.redX = n8;
                    this.metadata.redY = n9;
                    this.metadata.redZ = n10;
                    this.metadata.greenX = n11;
                    this.metadata.greenY = n12;
                    this.metadata.greenZ = n13;
                    this.metadata.blueX = n14;
                    this.metadata.blueY = n15;
                    this.metadata.blueZ = n16;
                    this.metadata.gammaRed = (int)l8;
                    this.metadata.gammaGreen = (int)l9;
                    this.metadata.gammaBlue = (int)l10;
                }
                int n17 = (int)((this.bitmapOffset - 14L - l2) / 4L);
                int n18 = n17 * 4;
                this.palette = new byte[n18];
                this.iis.readFully(this.palette, 0, n18);
                this.metadata.palette = this.palette;
                this.metadata.paletteSize = n17;
                switch ((int)this.compression) {
                    case 4: 
                    case 5: {
                        if (l2 == 108L) {
                            this.imageType = 17;
                            break;
                        }
                        if (l2 == 124L) {
                            this.imageType = 18;
                            break;
                        }
                        break block84;
                    }
                    default: {
                        if (this.bitsPerPixel == 1) {
                            this.imageType = 10;
                        } else if (this.bitsPerPixel == 4) {
                            this.imageType = 11;
                        } else if (this.bitsPerPixel == 8) {
                            this.imageType = 12;
                        } else if (this.bitsPerPixel == 16) {
                            this.imageType = 13;
                            if ((int)this.compression == 0) {
                                this.redMask = 31744;
                                this.greenMask = 992;
                                this.blueMask = 31;
                            }
                        } else if (this.bitsPerPixel == 24) {
                            this.imageType = 14;
                        } else if (this.bitsPerPixel == 32) {
                            this.imageType = 15;
                            if ((int)this.compression == 0) {
                                this.redMask = 0xFF0000;
                                this.greenMask = 65280;
                                this.blueMask = 255;
                            }
                        }
                        this.metadata.redMask = this.redMask;
                        this.metadata.greenMask = this.greenMask;
                        this.metadata.blueMask = this.blueMask;
                        this.metadata.alphaMask = this.alphaMask;
                        break;
                    }
                }
                break block84;
            }
            throw new IIOException(I18N.getString("BMPImageReader3"));
        }
        if (this.height > 0) {
            this.isBottomUp = true;
        } else {
            this.isBottomUp = false;
            this.height = Math.abs(this.height);
        }
        if (this.metadata.compression == 0 && (l = (long)(this.width * this.height * (this.bitsPerPixel / 8))) > this.bitmapFileSize - this.bitmapOffset) {
            throw new IIOException(I18N.getString("BMPImageReader9"));
        }
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        if (this.metadata.colorSpace == 3 || this.metadata.colorSpace == 4) {
            this.iis.mark();
            this.iis.skipBytes((long)n2 - l2);
            byte[] byArray = ReaderUtil.staggeredReadByteStream(this.iis, n);
            this.iis.reset();
            if (this.metadata.colorSpace == 3 && BMPImageReader.isLinkedProfileAllowed()) {
                String string = new String(byArray, "windows-1252");
                colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(string));
            } else if (this.metadata.colorSpace == 4) {
                colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(byArray));
            }
        }
        if (this.bitsPerPixel == 0 || this.compression == 4L || this.compression == 5L) {
            this.colorModel = null;
            this.sampleModel = null;
        } else if (this.bitsPerPixel == 1 || this.bitsPerPixel == 4 || this.bitsPerPixel == 8) {
            byte[] byArray;
            byte[] byArray2;
            byte[] byArray3;
            this.numBands = 1;
            if (this.bitsPerPixel == 8) {
                int[] nArray = new int[this.numBands];
                for (int i = 0; i < this.numBands; ++i) {
                    nArray[i] = this.numBands - 1 - i;
                }
                this.sampleModel = new PixelInterleavedSampleModel(0, this.width, this.height, this.numBands, this.numBands * this.width, nArray);
            } else {
                this.sampleModel = new MultiPixelPackedSampleModel(0, this.width, this.height, this.bitsPerPixel);
            }
            if (this.imageType == 0 || this.imageType == 1 || this.imageType == 2) {
                l2 = this.palette.length / 3;
                if (l2 > 256L) {
                    l2 = 256L;
                }
                byArray3 = new byte[(int)l2];
                byArray2 = new byte[(int)l2];
                byArray = new byte[(int)l2];
                for (int i = 0; i < (int)l2; ++i) {
                    int n19 = 3 * i;
                    byArray[i] = this.palette[n19];
                    byArray2[i] = this.palette[n19 + 1];
                    byArray3[i] = this.palette[n19 + 2];
                }
            } else {
                l2 = this.palette.length / 4;
                if (l2 > 256L) {
                    l2 = 256L;
                }
                byArray3 = new byte[(int)l2];
                byArray2 = new byte[(int)l2];
                byArray = new byte[(int)l2];
                int n20 = 0;
                while ((long)n20 < l2) {
                    int n21 = 4 * n20;
                    byArray[n20] = this.palette[n21];
                    byArray2[n20] = this.palette[n21 + 1];
                    byArray3[n20] = this.palette[n21 + 2];
                    ++n20;
                }
            }
            this.colorModel = ImageUtil.isIndicesForGrayscale(byArray3, byArray2, byArray) ? ImageUtil.createColorModel(null, this.sampleModel) : new IndexColorModel(this.bitsPerPixel, (int)l2, byArray3, byArray2, byArray);
        } else if (this.bitsPerPixel == 16) {
            this.numBands = 3;
            this.sampleModel = new SinglePixelPackedSampleModel(1, this.width, this.height, new int[]{this.redMask, this.greenMask, this.blueMask});
            this.colorModel = new DirectColorModel(colorSpace, 16, this.redMask, this.greenMask, this.blueMask, 0, false, 1);
        } else if (this.bitsPerPixel == 32) {
            int[] nArray;
            int n22 = this.numBands = this.alphaMask == 0 ? 3 : 4;
            if (this.numBands == 3) {
                int[] nArray2 = new int[3];
                nArray2[0] = this.redMask;
                nArray2[1] = this.greenMask;
                nArray = nArray2;
                nArray2[2] = this.blueMask;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = this.redMask;
                nArray3[1] = this.greenMask;
                nArray3[2] = this.blueMask;
                nArray = nArray3;
                nArray3[3] = this.alphaMask;
            }
            int[] nArray4 = nArray;
            this.sampleModel = new SinglePixelPackedSampleModel(3, this.width, this.height, nArray4);
            this.colorModel = new DirectColorModel(colorSpace, 32, this.redMask, this.greenMask, this.blueMask, this.alphaMask, false, 3);
        } else {
            this.numBands = 3;
            int[] nArray = new int[this.numBands];
            for (int i = 0; i < this.numBands; ++i) {
                nArray[i] = this.numBands - 1 - i;
            }
            this.sampleModel = new PixelInterleavedSampleModel(0, this.width, this.height, this.numBands, this.numBands * this.width, nArray);
            this.colorModel = ImageUtil.createColorModel(colorSpace, this.sampleModel);
        }
        this.originalSampleModel = this.sampleModel;
        this.originalColorModel = this.colorModel;
        this.iis.reset();
        this.iis.skipBytes(this.bitmapOffset);
        this.gotHeader = true;
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.checkIndex(n);
        try {
            this.readHeader();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IIOException(I18N.getString("BMPImageReader6"), illegalArgumentException);
        }
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        arrayList.add(new ImageTypeSpecifier(this.originalColorModel, this.originalSampleModel));
        return arrayList.iterator();
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkIndex(n);
        if (this.metadata == null) {
            try {
                this.readHeader();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IIOException(I18N.getString("BMPImageReader6"), illegalArgumentException);
            }
        }
        return this.metadata;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public boolean isRandomAccessEasy(int n) throws IOException {
        this.checkIndex(n);
        try {
            this.readHeader();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IIOException(I18N.getString("BMPImageReader6"), illegalArgumentException);
        }
        return this.metadata.compression == 0;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException(I18N.getString("BMPImageReader5"));
        }
        this.checkIndex(n);
        this.clearAbortRequest();
        this.processImageStarted(n);
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        try {
            this.readHeader();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IIOException(I18N.getString("BMPImageReader6"), illegalArgumentException);
        }
        this.sourceRegion = new Rectangle(0, 0, 0, 0);
        this.destinationRegion = new Rectangle(0, 0, 0, 0);
        BMPImageReader.computeRegions(imageReadParam, this.width, this.height, imageReadParam.getDestination(), this.sourceRegion, this.destinationRegion);
        this.scaleX = imageReadParam.getSourceXSubsampling();
        this.scaleY = imageReadParam.getSourceYSubsampling();
        this.sourceBands = imageReadParam.getSourceBands();
        this.destBands = imageReadParam.getDestinationBands();
        this.seleBand = this.sourceBands != null && this.destBands != null;
        boolean bl = this.noTransform = this.destinationRegion.equals(new Rectangle(0, 0, this.width, this.height)) || this.seleBand;
        if (!this.seleBand) {
            this.sourceBands = new int[this.numBands];
            this.destBands = new int[this.numBands];
            for (int i = 0; i < this.numBands; ++i) {
                this.destBands[i] = this.sourceBands[i] = i;
            }
        }
        this.bi = imageReadParam.getDestination();
        WritableRaster writableRaster = null;
        if (this.bi == null) {
            if (this.sampleModel != null && this.colorModel != null) {
                this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height);
                if (this.seleBand) {
                    this.sampleModel = this.sampleModel.createSubsetSampleModel(this.sourceBands);
                }
                writableRaster = Raster.createWritableRaster(this.sampleModel, new Point());
                this.bi = new BufferedImage(this.colorModel, writableRaster, false, null);
            }
        } else {
            writableRaster = this.bi.getWritableTile(0, 0);
            this.sampleModel = this.bi.getSampleModel();
            this.colorModel = this.bi.getColorModel();
            this.noTransform &= this.destinationRegion.equals(writableRaster.getBounds());
        }
        byte[] byArray = null;
        short[] sArray = null;
        int[] nArray = null;
        if (this.sampleModel != null) {
            if (this.sampleModel.getDataType() == 0) {
                byArray = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
            } else if (this.sampleModel.getDataType() == 1) {
                sArray = ((DataBufferUShort)writableRaster.getDataBuffer()).getData();
            } else if (this.sampleModel.getDataType() == 3) {
                nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
            }
        }
        block1 : switch (this.imageType) {
            case 0: {
                this.read1Bit(byArray);
                break;
            }
            case 1: {
                this.read4Bit(byArray);
                break;
            }
            case 2: {
                this.read8Bit(byArray);
                break;
            }
            case 3: {
                this.read24Bit(byArray);
                break;
            }
            case 4: {
                this.read1Bit(byArray);
                break;
            }
            case 5: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read4Bit(byArray);
                        break block1;
                    }
                    case 2: {
                        this.readRLE4(byArray);
                        break block1;
                    }
                }
                throw new IIOException(I18N.getString("BMPImageReader1"));
            }
            case 6: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read8Bit(byArray);
                        break block1;
                    }
                    case 1: {
                        this.readRLE8(byArray);
                        break block1;
                    }
                }
                throw new IIOException(I18N.getString("BMPImageReader1"));
            }
            case 7: {
                this.read24Bit(byArray);
                break;
            }
            case 8: {
                this.read16Bit(sArray);
                break;
            }
            case 9: {
                this.read32Bit(nArray);
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                this.bi = this.readEmbedded((int)this.compression, this.bi, imageReadParam);
                break;
            }
            case 10: {
                this.read1Bit(byArray);
                break;
            }
            case 11: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read4Bit(byArray);
                        break block1;
                    }
                    case 2: {
                        this.readRLE4(byArray);
                        break block1;
                    }
                }
                throw new IIOException(I18N.getString("BMPImageReader1"));
            }
            case 12: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read8Bit(byArray);
                        break block1;
                    }
                    case 1: {
                        this.readRLE8(byArray);
                        break block1;
                    }
                }
                throw new IIOException(I18N.getString("BMPImageReader1"));
            }
            case 13: {
                this.read16Bit(sArray);
                break;
            }
            case 14: {
                this.read24Bit(byArray);
                break;
            }
            case 15: {
                this.read32Bit(nArray);
            }
        }
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return this.bi;
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    @Override
    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = this.read(n, imageReadParam);
        return bufferedImage.getData();
    }

    private void resetHeaderInfo() {
        this.gotHeader = false;
        this.bi = null;
        this.originalSampleModel = null;
        this.sampleModel = null;
        this.originalColorModel = null;
        this.colorModel = null;
    }

    @Override
    public void reset() {
        super.reset();
        this.iis = null;
        this.resetHeaderInfo();
    }

    private void read1Bit(byte[] byArray) throws IOException {
        int n = (this.width + 7) / 8;
        int n2 = n % 4;
        if (n2 != 0) {
            n2 = 4 - n2;
        }
        int n3 = n + n2;
        if (this.noTransform) {
            int n4 = this.isBottomUp ? (this.height - 1) * n : 0;
            for (int i = 0; i < this.height && !this.abortRequested(); ++i) {
                this.iis.readFully(byArray, n4, n);
                this.iis.skipBytes(n2);
                n4 += this.isBottomUp ? -n : n;
                this.processImageUpdate(this.bi, 0, i, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i / (float)this.destinationRegion.height);
            }
        } else {
            int n5;
            byte[] byArray2 = new byte[n3];
            int n6 = ((MultiPixelPackedSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n5 = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(n3 * (this.height - 1 - n5));
            } else {
                this.iis.skipBytes(n3 * this.sourceRegion.y);
            }
            n5 = n3 * (this.scaleY - 1);
            int[] nArray = new int[this.destinationRegion.width];
            int[] nArray2 = new int[this.destinationRegion.width];
            int[] nArray3 = new int[this.destinationRegion.width];
            int[] nArray4 = new int[this.destinationRegion.width];
            int n7 = this.destinationRegion.x;
            int n8 = this.sourceRegion.x;
            int n9 = 0;
            while (n7 < this.destinationRegion.x + this.destinationRegion.width) {
                nArray3[n9] = n8 >> 3;
                nArray[n9] = 7 - (n8 & 7);
                nArray4[n9] = n7 >> 3;
                nArray2[n9] = 7 - (n7 & 7);
                ++n7;
                ++n9;
                n8 += this.scaleX;
            }
            n7 = this.destinationRegion.y * n6;
            if (this.isBottomUp) {
                n7 += (this.destinationRegion.height - 1) * n6;
            }
            n8 = 0;
            n9 = this.sourceRegion.y;
            while (n8 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.read(byArray2, 0, n3);
                for (int i = 0; i < this.destinationRegion.width; ++i) {
                    int n10 = byArray2[nArray3[i]] >> nArray[i] & 1;
                    int n11 = n7 + nArray4[i];
                    byArray[n11] = (byte)(byArray[n11] | n10 << nArray2[i]);
                }
                n7 += this.isBottomUp ? -n6 : n6;
                this.iis.skipBytes(n5);
                this.processImageUpdate(this.bi, 0, n8, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n8 / (float)this.destinationRegion.height);
                ++n8;
                n9 += this.scaleY;
            }
        }
    }

    private void read4Bit(byte[] byArray) throws IOException {
        int n = (this.width + 1) / 2;
        int n2 = n % 4;
        if (n2 != 0) {
            n2 = 4 - n2;
        }
        int n3 = n + n2;
        if (this.noTransform) {
            int n4 = this.isBottomUp ? (this.height - 1) * n : 0;
            for (int i = 0; i < this.height && !this.abortRequested(); ++i) {
                this.iis.readFully(byArray, n4, n);
                this.iis.skipBytes(n2);
                n4 += this.isBottomUp ? -n : n;
                this.processImageUpdate(this.bi, 0, i, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i / (float)this.destinationRegion.height);
            }
        } else {
            int n5;
            byte[] byArray2 = new byte[n3];
            int n6 = ((MultiPixelPackedSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n5 = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(n3 * (this.height - 1 - n5));
            } else {
                this.iis.skipBytes(n3 * this.sourceRegion.y);
            }
            n5 = n3 * (this.scaleY - 1);
            int[] nArray = new int[this.destinationRegion.width];
            int[] nArray2 = new int[this.destinationRegion.width];
            int[] nArray3 = new int[this.destinationRegion.width];
            int[] nArray4 = new int[this.destinationRegion.width];
            int n7 = this.destinationRegion.x;
            int n8 = this.sourceRegion.x;
            int n9 = 0;
            while (n7 < this.destinationRegion.x + this.destinationRegion.width) {
                nArray3[n9] = n8 >> 1;
                nArray[n9] = 1 - (n8 & 1) << 2;
                nArray4[n9] = n7 >> 1;
                nArray2[n9] = 1 - (n7 & 1) << 2;
                ++n7;
                ++n9;
                n8 += this.scaleX;
            }
            n7 = this.destinationRegion.y * n6;
            if (this.isBottomUp) {
                n7 += (this.destinationRegion.height - 1) * n6;
            }
            n8 = 0;
            n9 = this.sourceRegion.y;
            while (n8 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.read(byArray2, 0, n3);
                for (int i = 0; i < this.destinationRegion.width; ++i) {
                    int n10 = byArray2[nArray3[i]] >> nArray[i] & 0xF;
                    int n11 = n7 + nArray4[i];
                    byArray[n11] = (byte)(byArray[n11] | n10 << nArray2[i]);
                }
                n7 += this.isBottomUp ? -n6 : n6;
                this.iis.skipBytes(n5);
                this.processImageUpdate(this.bi, 0, n8, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n8 / (float)this.destinationRegion.height);
                ++n8;
                n9 += this.scaleY;
            }
        }
    }

    private void read8Bit(byte[] byArray) throws IOException {
        int n = this.width % 4;
        if (n != 0) {
            n = 4 - n;
        }
        int n2 = this.width + n;
        if (this.noTransform) {
            int n3 = this.isBottomUp ? (this.height - 1) * this.width : 0;
            for (int i = 0; i < this.height && !this.abortRequested(); ++i) {
                this.iis.readFully(byArray, n3, this.width);
                this.iis.skipBytes(n);
                n3 += this.isBottomUp ? -this.width : this.width;
                this.processImageUpdate(this.bi, 0, i, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i / (float)this.destinationRegion.height);
            }
        } else {
            int n4;
            byte[] byArray2 = new byte[n2];
            int n5 = ((ComponentSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n4 = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(n2 * (this.height - 1 - n4));
            } else {
                this.iis.skipBytes(n2 * this.sourceRegion.y);
            }
            n4 = n2 * (this.scaleY - 1);
            int n6 = this.destinationRegion.y * n5;
            if (this.isBottomUp) {
                n6 += (this.destinationRegion.height - 1) * n5;
            }
            n6 += this.destinationRegion.x;
            int n7 = 0;
            int n8 = this.sourceRegion.y;
            while (n7 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.read(byArray2, 0, n2);
                int n9 = 0;
                int n10 = this.sourceRegion.x;
                while (n9 < this.destinationRegion.width) {
                    byArray[n6 + n9] = byArray2[n10];
                    ++n9;
                    n10 += this.scaleX;
                }
                n6 += this.isBottomUp ? -n5 : n5;
                this.iis.skipBytes(n4);
                this.processImageUpdate(this.bi, 0, n7, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n7 / (float)this.destinationRegion.height);
                ++n7;
                n8 += this.scaleY;
            }
        }
    }

    private void read24Bit(byte[] byArray) throws IOException {
        int n = this.width * 3 % 4;
        if (n != 0) {
            n = 4 - n;
        }
        int n2 = this.width * 3;
        int n3 = n2 + n;
        if (this.noTransform) {
            int n4 = this.isBottomUp ? (this.height - 1) * this.width * 3 : 0;
            for (int i = 0; i < this.height && !this.abortRequested(); ++i) {
                this.iis.readFully(byArray, n4, n2);
                this.iis.skipBytes(n);
                n4 += this.isBottomUp ? -n2 : n2;
                this.processImageUpdate(this.bi, 0, i, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i / (float)this.destinationRegion.height);
            }
        } else {
            int n5;
            byte[] byArray2 = new byte[n3];
            n2 = ((ComponentSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n5 = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(n3 * (this.height - 1 - n5));
            } else {
                this.iis.skipBytes(n3 * this.sourceRegion.y);
            }
            n5 = n3 * (this.scaleY - 1);
            int n6 = this.destinationRegion.y * n2;
            if (this.isBottomUp) {
                n6 += (this.destinationRegion.height - 1) * n2;
            }
            n6 += this.destinationRegion.x * 3;
            int n7 = 0;
            int n8 = this.sourceRegion.y;
            while (n7 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.read(byArray2, 0, n3);
                int n9 = 0;
                int n10 = 3 * this.sourceRegion.x;
                while (n9 < this.destinationRegion.width) {
                    int n11 = 3 * n9 + n6;
                    for (int i = 0; i < this.destBands.length; ++i) {
                        byArray[n11 + this.destBands[i]] = byArray2[n10 + this.sourceBands[i]];
                    }
                    ++n9;
                    n10 += 3 * this.scaleX;
                }
                n6 += this.isBottomUp ? -n2 : n2;
                this.iis.skipBytes(n5);
                this.processImageUpdate(this.bi, 0, n7, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n7 / (float)this.destinationRegion.height);
                ++n7;
                n8 += this.scaleY;
            }
        }
    }

    private void read16Bit(short[] sArray) throws IOException {
        int n = this.width * 2 % 4;
        if (n != 0) {
            n = 4 - n;
        }
        int n2 = this.width + n / 2;
        if (this.noTransform) {
            int n3 = this.isBottomUp ? (this.height - 1) * this.width : 0;
            for (int i = 0; i < this.height && !this.abortRequested(); ++i) {
                this.iis.readFully(sArray, n3, this.width);
                this.iis.skipBytes(n);
                n3 += this.isBottomUp ? -this.width : this.width;
                this.processImageUpdate(this.bi, 0, i, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i / (float)this.destinationRegion.height);
            }
        } else {
            int n4;
            short[] sArray2 = new short[n2];
            int n5 = ((SinglePixelPackedSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n4 = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(n2 * (this.height - 1 - n4) << 1);
            } else {
                this.iis.skipBytes(n2 * this.sourceRegion.y << 1);
            }
            n4 = n2 * (this.scaleY - 1) << 1;
            int n6 = this.destinationRegion.y * n5;
            if (this.isBottomUp) {
                n6 += (this.destinationRegion.height - 1) * n5;
            }
            n6 += this.destinationRegion.x;
            int n7 = 0;
            int n8 = this.sourceRegion.y;
            while (n7 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.readFully(sArray2, 0, n2);
                int n9 = 0;
                int n10 = this.sourceRegion.x;
                while (n9 < this.destinationRegion.width) {
                    sArray[n6 + n9] = sArray2[n10];
                    ++n9;
                    n10 += this.scaleX;
                }
                n6 += this.isBottomUp ? -n5 : n5;
                this.iis.skipBytes(n4);
                this.processImageUpdate(this.bi, 0, n7, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n7 / (float)this.destinationRegion.height);
                ++n7;
                n8 += this.scaleY;
            }
        }
    }

    private void read32Bit(int[] nArray) throws IOException {
        if (this.noTransform) {
            int n = this.isBottomUp ? (this.height - 1) * this.width : 0;
            for (int i = 0; i < this.height && !this.abortRequested(); ++i) {
                this.iis.readFully(nArray, n, this.width);
                n += this.isBottomUp ? -this.width : this.width;
                this.processImageUpdate(this.bi, 0, i, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i / (float)this.destinationRegion.height);
            }
        } else {
            int n;
            int[] nArray2 = new int[this.width];
            int n2 = ((SinglePixelPackedSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(this.width * (this.height - 1 - n) << 2);
            } else {
                this.iis.skipBytes(this.width * this.sourceRegion.y << 2);
            }
            n = this.width * (this.scaleY - 1) << 2;
            int n3 = this.destinationRegion.y * n2;
            if (this.isBottomUp) {
                n3 += (this.destinationRegion.height - 1) * n2;
            }
            n3 += this.destinationRegion.x;
            int n4 = 0;
            int n5 = this.sourceRegion.y;
            while (n4 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.readFully(nArray2, 0, this.width);
                int n6 = 0;
                int n7 = this.sourceRegion.x;
                while (n6 < this.destinationRegion.width) {
                    nArray[n3 + n6] = nArray2[n7];
                    ++n6;
                    n7 += this.scaleX;
                }
                n3 += this.isBottomUp ? -n2 : n2;
                this.iis.skipBytes(n);
                this.processImageUpdate(this.bi, 0, n4, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n4 / (float)this.destinationRegion.height);
                ++n4;
                n5 += this.scaleY;
            }
        }
    }

    private void readRLE8(byte[] byArray) throws IOException {
        int n = (int)this.imageSize;
        if (n == 0) {
            n = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int n2 = 0;
        int n3 = this.width % 4;
        if (n3 != 0) {
            n2 = 4 - n3;
        }
        byte[] byArray2 = ReaderUtil.staggeredReadByteStream(this.iis, n);
        this.decodeRLE8(n, n2, byArray2, byArray);
    }

    private void decodeRLE8(int n, int n2, byte[] byArray, byte[] byArray2) throws IOException {
        byte[] byArray3 = new byte[this.width * this.height];
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = this.isBottomUp ? this.height - 1 : 0;
        int n6 = ((ComponentSampleModel)this.sampleModel).getScanlineStride();
        int n7 = 0;
        while (n3 != n) {
            block17: {
                int n8;
                int n9;
                block16: {
                    if ((n9 = byArray[n3++] & 0xFF) != 0) break block16;
                    switch (byArray[n3++] & 0xFF) {
                        case 0: {
                            int n10;
                            int n11;
                            if (n5 >= this.sourceRegion.y && n5 < this.sourceRegion.y + this.sourceRegion.height) {
                                if (this.noTransform) {
                                    n8 = n5 * this.width;
                                    for (n11 = 0; n11 < this.width; ++n11) {
                                        byArray2[n8++] = byArray3[n11];
                                    }
                                    this.processImageUpdate(this.bi, 0, n5, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                                    ++n7;
                                } else if ((n5 - this.sourceRegion.y) % this.scaleY == 0) {
                                    n8 = (n5 - this.sourceRegion.y) / this.scaleY + this.destinationRegion.y;
                                    n11 = n8 * n6;
                                    n11 += this.destinationRegion.x;
                                    for (n10 = this.sourceRegion.x; n10 < this.sourceRegion.x + this.sourceRegion.width; n10 += this.scaleX) {
                                        byArray2[n11++] = byArray3[n10];
                                    }
                                    this.processImageUpdate(this.bi, 0, n8, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                                    ++n7;
                                }
                            }
                            this.processImageProgress(100.0f * (float)n7 / (float)this.destinationRegion.height);
                            n5 += this.isBottomUp ? -1 : 1;
                            n4 = 0;
                            if (this.abortRequested()) {
                                bl = true;
                                break;
                            }
                            break block17;
                        }
                        case 1: {
                            bl = true;
                            break;
                        }
                        case 2: {
                            n8 = byArray[n3++] & 0xFF;
                            int n11 = byArray[n3] & 0xFF;
                            n4 += n8 + n11 * this.width;
                            break;
                        }
                        default: {
                            int n10 = byArray[n3 - 1] & 0xFF;
                            for (int i = 0; i < n10; ++i) {
                                byArray3[n4++] = (byte)(byArray[n3++] & 0xFF);
                            }
                            if ((n10 & 1) == 1) {
                                ++n3;
                                break;
                            }
                            break block17;
                        }
                    }
                    break block17;
                }
                for (n8 = 0; n8 < n9; ++n8) {
                    byArray3[n4++] = (byte)(byArray[n3] & 0xFF);
                }
                ++n3;
            }
            if (!bl) continue;
            break;
        }
    }

    private void readRLE4(byte[] byArray) throws IOException {
        int n = (int)this.imageSize;
        if (n == 0) {
            n = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int n2 = 0;
        int n3 = this.width % 4;
        if (n3 != 0) {
            n2 = 4 - n3;
        }
        byte[] byArray2 = ReaderUtil.staggeredReadByteStream(this.iis, n);
        this.decodeRLE4(n, n2, byArray2, byArray);
    }

    private void decodeRLE4(int n, int n2, byte[] byArray, byte[] byArray2) throws IOException {
        byte[] byArray3 = new byte[this.width];
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = this.isBottomUp ? this.height - 1 : 0;
        int n6 = ((MultiPixelPackedSampleModel)this.sampleModel).getScanlineStride();
        int n7 = 0;
        while (n3 != n) {
            block20: {
                int n8;
                int n9;
                block19: {
                    if ((n9 = byArray[n3++] & 0xFF) != 0) break block19;
                    switch (byArray[n3++] & 0xFF) {
                        case 0: {
                            int n10;
                            int n11;
                            if (n5 >= this.sourceRegion.y && n5 < this.sourceRegion.y + this.sourceRegion.height) {
                                if (this.noTransform) {
                                    int n12 = n5 * (this.width + 1 >> 1);
                                    n11 = 0;
                                    for (n8 = 0; n8 < this.width >> 1; ++n8) {
                                        byArray2[n12++] = (byte)(byArray3[n11++] << 4 | byArray3[n11++]);
                                    }
                                    if ((this.width & 1) == 1) {
                                        int n13 = n12;
                                        byArray2[n13] = (byte)(byArray2[n13] | byArray3[this.width - 1] << 4);
                                    }
                                    this.processImageUpdate(this.bi, 0, n5, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                                    ++n7;
                                } else if ((n5 - this.sourceRegion.y) % this.scaleY == 0) {
                                    int n14 = (n5 - this.sourceRegion.y) / this.scaleY + this.destinationRegion.y;
                                    n8 = n14 * n6;
                                    n8 += this.destinationRegion.x >> 1;
                                    n11 = 1 - (this.destinationRegion.x & 1) << 2;
                                    for (n10 = this.sourceRegion.x; n10 < this.sourceRegion.x + this.sourceRegion.width; n10 += this.scaleX) {
                                        int n15 = n8++;
                                        byArray2[n15] = (byte)(byArray2[n15] | byArray3[n10] << n11);
                                        if ((n11 += 4) == 4) {
                                            // empty if block
                                        }
                                        n11 &= 7;
                                    }
                                    this.processImageUpdate(this.bi, 0, n14, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                                    ++n7;
                                }
                            }
                            this.processImageProgress(100.0f * (float)n7 / (float)this.destinationRegion.height);
                            n5 += this.isBottomUp ? -1 : 1;
                            n4 = 0;
                            if (this.abortRequested()) {
                                bl = true;
                                break;
                            }
                            break block20;
                        }
                        case 1: {
                            bl = true;
                            break;
                        }
                        case 2: {
                            int n16 = byArray[n3++] & 0xFF;
                            n8 = byArray[n3] & 0xFF;
                            n4 += n16 + n8 * this.width;
                            break;
                        }
                        default: {
                            int n10;
                            int n11 = byArray[n3 - 1] & 0xFF;
                            for (n10 = 0; n10 < n11; ++n10) {
                                byArray3[n4++] = (byte)((n10 & 1) == 0 ? (byArray[n3] & 0xF0) >> 4 : byArray[n3++] & 0xF);
                            }
                            if ((n11 & 1) == 1) {
                                ++n3;
                            }
                            if (((int)Math.ceil(n11 / 2) & 1) == 1) {
                                ++n3;
                                break;
                            }
                            break block20;
                        }
                    }
                    break block20;
                }
                int[] nArray = new int[]{(byArray[n3] & 0xF0) >> 4, byArray[n3] & 0xF};
                for (n8 = 0; n8 < n9 && n4 < this.width; ++n8) {
                    byArray3[n4++] = (byte)nArray[n8 & 1];
                }
                ++n3;
            }
            if (!bl) continue;
            break;
        }
    }

    private BufferedImage readEmbedded(int n, BufferedImage bufferedImage, ImageReadParam imageReadParam) throws IOException {
        Object object;
        String string;
        switch (n) {
            case 4: {
                string = "JPEG";
                break;
            }
            case 5: {
                string = "PNG";
                break;
            }
            default: {
                throw new IOException("Unexpected compression type: " + n);
            }
        }
        ImageReader imageReader = ImageIO.getImageReadersByFormatName(string).next();
        if (imageReader == null) {
            throw new RuntimeException(I18N.getString("BMPImageReader4") + " " + string);
        }
        byte[] byArray = new byte[(int)this.imageSize];
        this.iis.read(byArray);
        imageReader.setInput(ImageIO.createImageInputStream(new ByteArrayInputStream(byArray)));
        if (bufferedImage == null) {
            object = imageReader.getImageTypes(0).next();
            bufferedImage = ((ImageTypeSpecifier)object).createBufferedImage(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height);
        }
        imageReader.addIIOReadProgressListener(new EmbeddedProgressAdapter(){

            @Override
            public void imageProgress(ImageReader imageReader, float f) {
                BMPImageReader.this.processImageProgress(f);
            }
        });
        imageReader.addIIOReadUpdateListener(new IIOReadUpdateListener(){

            @Override
            public void imageUpdate(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
                BMPImageReader.this.processImageUpdate(bufferedImage, n, n2, n3, n4, n5, n6, nArray);
            }

            @Override
            public void passComplete(ImageReader imageReader, BufferedImage bufferedImage) {
                BMPImageReader.this.processPassComplete(bufferedImage);
            }

            @Override
            public void passStarted(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
                BMPImageReader.this.processPassStarted(bufferedImage, n, n2, n3, n4, n5, n6, n7, nArray);
            }

            @Override
            public void thumbnailPassComplete(ImageReader imageReader, BufferedImage bufferedImage) {
            }

            @Override
            public void thumbnailPassStarted(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
            }

            @Override
            public void thumbnailUpdate(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
            }
        });
        imageReader.addIIOReadWarningListener(new IIOReadWarningListener(){

            @Override
            public void warningOccurred(ImageReader imageReader, String string) {
                BMPImageReader.this.processWarningOccurred(string);
            }
        });
        object = imageReader.getDefaultReadParam();
        ((ImageReadParam)object).setDestination(bufferedImage);
        ((ImageReadParam)object).setDestinationBands(imageReadParam.getDestinationBands());
        ((IIOParam)object).setDestinationOffset(imageReadParam.getDestinationOffset());
        ((IIOParam)object).setSourceBands(imageReadParam.getSourceBands());
        ((IIOParam)object).setSourceRegion(imageReadParam.getSourceRegion());
        ((IIOParam)object).setSourceSubsampling(imageReadParam.getSourceXSubsampling(), imageReadParam.getSourceYSubsampling(), imageReadParam.getSubsamplingXOffset(), imageReadParam.getSubsamplingYOffset());
        imageReader.read(0, (ImageReadParam)object);
        return bufferedImage;
    }

    private static boolean isLinkedProfileAllowed() {
        if (isLinkedProfileAllowed == null) {
            PrivilegedAction<Boolean> privilegedAction = new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("sun.imageio.bmp.enableLinkedProfiles");
                }
            };
            isLinkedProfileAllowed = AccessController.doPrivileged(privilegedAction);
        }
        return isLinkedProfileAllowed;
    }

    private class EmbeddedProgressAdapter
    implements IIOReadProgressListener {
        private EmbeddedProgressAdapter() {
        }

        @Override
        public void imageComplete(ImageReader imageReader) {
        }

        @Override
        public void imageProgress(ImageReader imageReader, float f) {
        }

        @Override
        public void imageStarted(ImageReader imageReader, int n) {
        }

        @Override
        public void thumbnailComplete(ImageReader imageReader) {
        }

        @Override
        public void thumbnailProgress(ImageReader imageReader, float f) {
        }

        @Override
        public void thumbnailStarted(ImageReader imageReader, int n, int n2) {
        }

        @Override
        public void sequenceComplete(ImageReader imageReader) {
        }

        @Override
        public void sequenceStarted(ImageReader imageReader, int n) {
        }

        @Override
        public void readAborted(ImageReader imageReader) {
        }
    }
}

