/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

public class OSInfo {
    public static final WindowsVersion WINDOWS_UNKNOWN = new WindowsVersion(-1, -1);
    public static final WindowsVersion WINDOWS_95 = new WindowsVersion(4, 0);
    public static final WindowsVersion WINDOWS_98 = new WindowsVersion(4, 10);
    public static final WindowsVersion WINDOWS_ME = new WindowsVersion(4, 90);
    public static final WindowsVersion WINDOWS_2000 = new WindowsVersion(5, 0);
    public static final WindowsVersion WINDOWS_XP = new WindowsVersion(5, 1);
    public static final WindowsVersion WINDOWS_2003 = new WindowsVersion(5, 2);
    public static final WindowsVersion WINDOWS_VISTA = new WindowsVersion(6, 0);
    private static final String OS_NAME = "os.name";
    private static final String OS_VERSION = "os.version";
    private static final Map<String, WindowsVersion> windowsVersionMap = new HashMap<String, WindowsVersion>();
    private static final PrivilegedAction<OSType> osTypeAction;

    private OSInfo() {
    }

    public static OSType getOSType() throws SecurityException {
        String string = System.getProperty(OS_NAME);
        if (string != null) {
            if (string.contains("Windows")) {
                return OSType.WINDOWS;
            }
            if (string.contains("Linux")) {
                return OSType.LINUX;
            }
            if (string.contains("Solaris") || string.contains("SunOS")) {
                return OSType.SOLARIS;
            }
            if (string.contains("OS X")) {
                return OSType.MACOSX;
            }
        }
        return OSType.UNKNOWN;
    }

    public static PrivilegedAction<OSType> getOSTypeAction() {
        return osTypeAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WindowsVersion getWindowsVersion() throws SecurityException {
        String string = System.getProperty(OS_VERSION);
        if (string == null) {
            return WINDOWS_UNKNOWN;
        }
        Map<String, WindowsVersion> map = windowsVersionMap;
        synchronized (map) {
            WindowsVersion windowsVersion = windowsVersionMap.get(string);
            if (windowsVersion == null) {
                String[] stringArray = string.split("\\.");
                if (stringArray.length == 2) {
                    try {
                        windowsVersion = new WindowsVersion(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        return WINDOWS_UNKNOWN;
                    }
                } else {
                    return WINDOWS_UNKNOWN;
                }
                windowsVersionMap.put(string, windowsVersion);
            }
            return windowsVersion;
        }
    }

    static {
        windowsVersionMap.put(WINDOWS_95.toString(), WINDOWS_95);
        windowsVersionMap.put(WINDOWS_98.toString(), WINDOWS_98);
        windowsVersionMap.put(WINDOWS_ME.toString(), WINDOWS_ME);
        windowsVersionMap.put(WINDOWS_2000.toString(), WINDOWS_2000);
        windowsVersionMap.put(WINDOWS_XP.toString(), WINDOWS_XP);
        windowsVersionMap.put(WINDOWS_2003.toString(), WINDOWS_2003);
        windowsVersionMap.put(WINDOWS_VISTA.toString(), WINDOWS_VISTA);
        osTypeAction = new PrivilegedAction<OSType>(){

            @Override
            public OSType run() {
                return OSInfo.getOSType();
            }
        };
    }

    public static class WindowsVersion
    implements Comparable<WindowsVersion> {
        private final int major;
        private final int minor;

        private WindowsVersion(int n, int n2) {
            this.major = n;
            this.minor = n2;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        @Override
        public int compareTo(WindowsVersion windowsVersion) {
            int n = this.major - windowsVersion.getMajor();
            if (n == 0) {
                n = this.minor - windowsVersion.getMinor();
            }
            return n;
        }

        public boolean equals(Object object) {
            return object instanceof WindowsVersion && this.compareTo((WindowsVersion)object) == 0;
        }

        public int hashCode() {
            return 31 * this.major + this.minor;
        }

        public String toString() {
            return this.major + "." + this.minor;
        }
    }

    public static enum OSType {
        WINDOWS,
        LINUX,
        SOLARIS,
        MACOSX,
        UNKNOWN;

    }
}

