/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.TimeUnit;
import sun.misc.SharedSecrets;
import sun.misc.WispEngineAccess;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Net;
import sun.nio.ch.WispSocketLockSupport;

public class WispUdpSocketImpl {
    private static WispEngineAccess WEA = SharedSecrets.getWispEngineAccess();
    private WispSocketLockSupport wispSocketLockSupport = new WispSocketLockSupport();
    private DatagramChannelImpl dc;
    private DatagramSocket so;
    private volatile int timeout = 0;

    public WispUdpSocketImpl(DatagramSocket datagramSocket) {
        this.so = datagramSocket;
    }

    public WispUdpSocketImpl(DatagramChannel datagramChannel, DatagramSocket datagramSocket) {
        this.so = datagramSocket;
        this.dc = (DatagramChannelImpl)datagramChannel;
    }

    public void bind(SocketAddress socketAddress) throws SocketException {
        try {
            if (socketAddress == null) {
                socketAddress = new InetSocketAddress(0);
            }
            this.getChannelImpl().bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void connect(InetAddress inetAddress, int n) {
        try {
            this.connect(new InetSocketAddress(inetAddress, n));
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public void connect(SocketAddress socketAddress) throws SocketException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("Address can't be null");
        }
        InetSocketAddress inetSocketAddress = Net.asInetSocketAddress(socketAddress);
        int n = inetSocketAddress.getPort();
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("connect: " + n);
        }
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: null address");
        }
        if (this.isClosed()) {
            return;
        }
        try {
            this.getChannelImpl().connect(socketAddress);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void disconnect() {
        try {
            this.getChannelImpl().disconnect();
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    public boolean isBound() {
        return this.dc != null && this.dc.localAddress() != null;
    }

    public boolean isConnected() {
        return this.dc != null && this.dc.remoteAddress() != null;
    }

    public InetAddress getInetAddress() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getAddress() : null;
    }

    public int getPort() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getPort() : -1;
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        try {
            this.wispSocketLockSupport.beginWrite();
            this.send0(datagramPacket);
        }
        finally {
            this.wispSocketLockSupport.endWrite();
        }
    }

    private SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        try {
            this.wispSocketLockSupport.beginRead();
            SocketAddress socketAddress = this.receive0(byteBuffer);
            return socketAddress;
        }
        finally {
            this.wispSocketLockSupport.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send0(DatagramPacket datagramPacket) throws IOException {
        DatagramChannelImpl datagramChannelImpl = this.getChannelImpl();
        try {
            int n;
            boolean bl;
            ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
            boolean bl2 = bl = datagramChannelImpl.isConnected() && datagramPacket.getAddress() == null;
            if (bl) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramChannelImpl.remoteAddress();
                datagramPacket.setPort(inetSocketAddress.getPort());
                datagramPacket.setAddress(inetSocketAddress.getAddress());
            }
            if ((bl ? datagramChannelImpl.write(byteBuffer) : datagramChannelImpl.send(byteBuffer, datagramPacket.getSocketAddress())) == (n = byteBuffer.remaining())) {
                return;
            }
            if (this.getSoTimeout() > 0) {
                WEA.addTimer(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.getSoTimeout()));
            }
            do {
                WEA.registerEvent(datagramChannelImpl, 4);
                WEA.park(-1L);
                if (this.getSoTimeout() > 0 && WEA.isTimeout()) {
                    throw new SocketTimeoutException("time out");
                }
                if (bl) {
                    datagramChannelImpl.write(byteBuffer);
                    continue;
                }
                datagramChannelImpl.send(byteBuffer, datagramPacket.getSocketAddress());
            } while (byteBuffer.remaining() > 0);
        }
        catch (IOException iOException) {
            Net.translateException(iOException);
        }
        finally {
            if (this.getSoTimeout() > 0) {
                WEA.cancelTimer();
            }
            WEA.unregisterEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress receive0(ByteBuffer byteBuffer) throws IOException {
        SocketAddress socketAddress;
        DatagramChannelImpl datagramChannelImpl = this.getChannelImpl();
        try {
            socketAddress = datagramChannelImpl.receive(byteBuffer);
            if (socketAddress != null) {
                SocketAddress socketAddress2 = socketAddress;
                return socketAddress2;
            }
            if (this.getSoTimeout() > 0) {
                WEA.addTimer(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.getSoTimeout()));
            }
            do {
                WEA.registerEvent(datagramChannelImpl, 1);
                WEA.park(-1L);
                if (this.getSoTimeout() <= 0 || !WEA.isTimeout()) continue;
                throw new SocketTimeoutException("time out");
            } while ((socketAddress = datagramChannelImpl.receive(byteBuffer)) == null);
        }
        finally {
            if (this.getSoTimeout() > 0) {
                WEA.cancelTimer();
            }
            WEA.unregisterEvent();
        }
        return socketAddress;
    }

    public int receive(DatagramPacket datagramPacket, int n) throws IOException {
        int n2 = 0;
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), n);
            SocketAddress socketAddress = this.receive(byteBuffer);
            datagramPacket.setSocketAddress(socketAddress);
            n2 = byteBuffer.position() - datagramPacket.getOffset();
        }
        catch (IOException iOException) {
            Net.translateException(iOException);
        }
        return n2;
    }

    public InetAddress getLocalAddress() {
        SocketAddress socketAddress;
        if (this.isClosed()) {
            return null;
        }
        DatagramChannelImpl datagramChannelImpl = null;
        try {
            datagramChannelImpl = this.getChannelImpl();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        SocketAddress socketAddress2 = socketAddress = datagramChannelImpl == null ? null : datagramChannelImpl.localAddress();
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        InetAddress inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkConnect(inetAddress.getHostAddress(), -1);
            }
            catch (SecurityException securityException) {
                return new InetSocketAddress(0).getAddress();
            }
        }
        return inetAddress;
    }

    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            SocketAddress socketAddress = this.getChannelImpl().getLocalAddress();
            if (socketAddress != null) {
                return ((InetSocketAddress)socketAddress).getPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public void setSoTimeout(int n) throws SocketException {
        this.timeout = n;
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    private void setBooleanOption(SocketOption<Boolean> socketOption, boolean bl) throws SocketException {
        try {
            this.getChannelImpl().setOption((SocketOption)socketOption, (Object)bl);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private void setIntOption(SocketOption<Integer> socketOption, int n) throws SocketException {
        try {
            this.getChannelImpl().setOption((SocketOption)socketOption, (Object)n);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private boolean getBooleanOption(SocketOption<Boolean> socketOption) throws SocketException {
        try {
            return this.getChannelImpl().getOption(socketOption);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return false;
        }
    }

    private int getIntOption(SocketOption<Integer> socketOption) throws SocketException {
        try {
            return this.getChannelImpl().getOption(socketOption);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return -1;
        }
    }

    public void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid send size");
        }
        this.setIntOption(StandardSocketOptions.SO_SNDBUF, n);
    }

    public int getSendBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_SNDBUF);
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid receive size");
        }
        this.setIntOption(StandardSocketOptions.SO_RCVBUF, n);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_RCVBUF);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_REUSEADDR, bl);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_REUSEADDR);
    }

    public void setBroadcast(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_BROADCAST, bl);
    }

    public boolean getBroadcast() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_BROADCAST);
    }

    public void setTrafficClass(int n) throws SocketException {
        this.setIntOption(StandardSocketOptions.IP_TOS, n);
    }

    public int getTrafficClass() throws SocketException {
        return this.getIntOption(StandardSocketOptions.IP_TOS);
    }

    public void close() {
        if (this.dc != null) {
            try {
                this.dc.close();
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
            this.wispSocketLockSupport.unparkBlockedWispTask();
        }
    }

    public boolean isClosed() {
        return this.dc != null && !this.dc.isOpen();
    }

    public DatagramChannel getChannel() {
        return this.dc;
    }

    private DatagramChannelImpl getChannelImpl() throws SocketException {
        if (this.dc == null) {
            try {
                this.dc = (DatagramChannelImpl)DatagramChannel.open();
                this.dc.configureBlocking(false);
            }
            catch (IOException iOException) {
                throw new SocketException(iOException.getMessage());
            }
        }
        return this.dc;
    }
}

