/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.rdma;

import java.net.ProtocolFamily;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.util.HashMap;
import java.util.Map;
import sun.nio.ch.rdma.RdmaNet;
import sun.nio.ch.rdma.RdmaOptionKey;

class RdmaSocketOptionRegistry {
    private RdmaSocketOptionRegistry() {
    }

    public static RdmaOptionKey findOption(SocketOption<?> socketOption, ProtocolFamily protocolFamily) {
        RegistryKey registryKey = new RegistryKey(socketOption, protocolFamily);
        return LazyInitialization.options.get(registryKey);
    }

    private static class LazyInitialization {
        static final Map<RegistryKey, RdmaOptionKey> options = LazyInitialization.options();

        private LazyInitialization() {
        }

        private static Map<RegistryKey, RdmaOptionKey> options() {
            HashMap<RegistryKey, RdmaOptionKey> hashMap = new HashMap<RegistryKey, RdmaOptionKey>();
            hashMap.put(new RegistryKey(StandardSocketOptions.SO_SNDBUF, RdmaNet.UNSPEC), new RdmaOptionKey(1, 7));
            hashMap.put(new RegistryKey(StandardSocketOptions.SO_RCVBUF, RdmaNet.UNSPEC), new RdmaOptionKey(1, 8));
            hashMap.put(new RegistryKey(StandardSocketOptions.SO_REUSEADDR, RdmaNet.UNSPEC), new RdmaOptionKey(1, 2));
            hashMap.put(new RegistryKey(StandardSocketOptions.TCP_NODELAY, RdmaNet.UNSPEC), new RdmaOptionKey(6, 1));
            return hashMap;
        }
    }

    private static class RegistryKey {
        private final SocketOption<?> name;
        private final ProtocolFamily family;

        RegistryKey(SocketOption<?> socketOption, ProtocolFamily protocolFamily) {
            this.name = socketOption;
            this.family = protocolFamily;
        }

        public int hashCode() {
            return this.name.hashCode() + this.family.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof RegistryKey)) {
                return false;
            }
            RegistryKey registryKey = (RegistryKey)object;
            if (this.name != registryKey.name) {
                return false;
            }
            return this.family == registryKey.family;
        }
    }
}

