/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.cds;

import com.alibaba.jvm.cds.Classes4CDS;
import com.alibaba.jvm.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class CDSDumper {
    private static final String[] MEM_ARGS = new String[]{"-XX:MaxHeapSize", "-XX:InitialHeapSize", "-Xms", "-Xmn", "-Xmx", "-Xss", "-XX:MaxMetaspaceSize", "-XX:MetaspaceSize", "-XX:MaxDirectMemorySize", "-XX:NewSize", "-XX:MaxNewSize"};
    private static Info info;
    private static final int ARGC = 9;

    public static Info getInfo() {
        return info;
    }

    private static void runClasses4CDS() {
        try {
            Classes4CDS.main(CDSDumper.info.originClassListName, CDSDumper.info.finalClassListName, CDSDumper.info.dirPath);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static void handleCompressedOopsAndClassPointers(List<String> arguments) {
        String[] xmxOptions = new String[]{"-Xmx", "-XX:MaxHeapSize="};
        for (int i = arguments.size() - 1; i >= 0; --i) {
            String argument = arguments.get(i);
            long value = 0L;
            long KB = 1024L;
            long MB = 0x100000L;
            long GB = 0x40000000L;
            long TB = 0x10000000000L;
            for (String xmx : xmxOptions) {
                if (!argument.startsWith(xmx)) continue;
                String s = argument.substring(xmx.length());
                int radix = 10;
                if (s.startsWith("0x")) {
                    radix = 16;
                    s = s.substring(2);
                }
                char lastChar = s.charAt(s.length() - 1);
                if (Character.isDigit(lastChar = Character.toUpperCase(lastChar))) {
                    value = Long.parseLong(s, radix);
                    break;
                }
                String prefix = s.substring(0, s.length() - 1);
                long number = Long.parseLong(prefix, radix);
                if (lastChar == 'T') {
                    value = number * 0x10000000000L;
                    continue;
                }
                if (lastChar == 'G') {
                    value = number * 0x40000000L;
                    continue;
                }
                if (lastChar == 'M') {
                    value = number * 0x100000L;
                    continue;
                }
                if (lastChar == 'K') {
                    value = number * 1024L;
                    continue;
                }
                throw new Error("Parse error: ShouldNotReachHere: " + argument);
            }
            if (value == 0L || value < 0x800000000L) continue;
            arguments.add("-XX:-UseCompressedOops");
            arguments.add("-XX:-UseCompressedClassPointers");
            break;
        }
    }

    private static void runDumpJSA() {
        String jdkHome = Utils.getJDKHome();
        LinkedList<String> arguments = new LinkedList<String>(Arrays.asList(CDSDumper.info.runtimeCommandLine.split("(?<!\\\\)[\r\t ]")));
        arguments.removeIf(arg -> arg.startsWith("-Xshare:off") || arg.startsWith("-XX:SharedClassListFile") || arg.startsWith("-XX:DumpLoadedClassList") || arg.startsWith("-XX:+UseWisp2") || arg.startsWith("-Xquickstart") || arg.startsWith("-agentlib:jdwp") || arg.startsWith("-Dcom.sun.management.jmxremote.port") || arg.startsWith("-Dcom.sun.management.jmxremote.rmi.port") || arg.startsWith("-Xdebug") || arg.startsWith("-Xrunjdwp") || arg.startsWith("-javaagent") || arg.trim().isEmpty());
        CDSDumper.handleCompressedOopsAndClassPointers(arguments);
        for (String memArg : MEM_ARGS) {
            arguments.removeIf(arg -> arg.startsWith(memArg));
        }
        Utils.printArgs(arguments, "[Current JVM commands] ", CDSDumper.info.verbose);
        ArrayList<String> command = new ArrayList<String>();
        command.add(Paths.get(jdkHome, "bin", "java").toString());
        command.addAll(arguments);
        command.add("-XX:+UnlockDiagnosticVMOptions");
        command.add("-Xshare:dump");
        command.add("-XX:SharedClassListFile=" + CDSDumper.info.finalClassListName);
        command.add("-XX:SharedArchiveFile=" + CDSDumper.info.jsaName);
        command.add("-XX:SharedReadWriteSize=512M");
        command.add("-XX:+UnlockExperimentalVMOptions");
        command.add("-XX:+EagerAppCDSLegacyVerisonSupport");
        command.add("-XX:+DisableAttachMechanism");
        if (CDSDumper.info.eager) {
            command.add("-XX:+EagerAppCDS");
            command.add("-Xbootclasspath/a:" + Paths.get(jdkHome, "lib", System.getProperty("os.arch"), CDSDumper.info.agent).toString());
        }
        command.add("-cp");
        command.add(CDSDumper.info.cp);
        Utils.printArgs(command, "[Dump JSA Command] ", CDSDumper.info.verbose);
        try {
            Utils.runProcess(command, CDSDumper.info.verbose, null, null, new Utils.LogInfo(Paths.get(CDSDumper.info.dirPath, "logs"), "jsa.log"));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void prepareInfo(String dirPath) throws Exception {
        assert (Objects.nonNull(dirPath));
        assert (Objects.nonNull(CDSDumper.info.originClassListName));
        assert (Objects.nonNull(CDSDumper.info.finalClassListName));
        assert (Objects.nonNull(CDSDumper.info.jsaName));
        File dir = new File(dirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RuntimeException(dirPath + " is not a dir? ");
        }
        CDSDumper.info.originClassListName = Paths.get(dirPath, CDSDumper.info.originClassListName).toString();
        CDSDumper.info.finalClassListName = Paths.get(dirPath, CDSDumper.info.finalClassListName).toString();
        CDSDumper.info.jsaName = Paths.get(dirPath, CDSDumper.info.jsaName).toString();
    }

    public static void dumpJSA() throws Exception {
        CDSDumper.prepareInfo(CDSDumper.info.dirPath);
        CDSDumper.runClasses4CDS();
        CDSDumper.runDumpJSA();
        CDSDumper.deleteTempFiles();
    }

    private static void deleteTempFiles() {
        Classes4CDS.getInstance().tempFiles.forEach(f -> CDSDumper.doDelete(f));
    }

    private static void doDelete(String source) {
        File f = new File(source);
        if (f.exists()) {
            if (f.isFile()) {
                if (!f.delete()) {
                    throw new Error("Clean up temporary file : " + source + " failed!");
                }
            } else if (f.isDirectory()) {
                Path dir = Paths.get(source, new String[0]);
                try {
                    Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    throw new Error("Clean up temporary directory: " + source + " failed!", e);
                }
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 9) {
            throw new Error("args num should be 9. Now " + args.length);
        }
        String dirPath = args[0];
        String originClassListName = args[1];
        String finalClassListName = args[2];
        boolean eager = Boolean.parseBoolean(args[3]);
        String jsaName = args[4];
        String agent = args[5];
        boolean verbose = Boolean.parseBoolean(args[6]);
        String runtimeCommandLine = args[7];
        String cp = args[8];
        info = new Info(dirPath, originClassListName, finalClassListName, eager, jsaName, agent, verbose, runtimeCommandLine, cp);
        try {
            CDSDumper.dumpJSA();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static class Info {
        public String dirPath;
        public String originClassListName;
        public String finalClassListName;
        public boolean eager;
        public String jsaName;
        public String agent;
        public boolean verbose;
        public String runtimeCommandLine;
        public String cp;

        public Info(String dirPath, String originClassListName, String finalClassListName, boolean eager, String jsaName, String agent, boolean verbose, String runtimeCommandLine, String cp) {
            this.dirPath = dirPath;
            this.originClassListName = originClassListName;
            this.finalClassListName = finalClassListName;
            this.eager = eager;
            this.jsaName = jsaName;
            this.agent = agent;
            this.verbose = verbose;
            this.runtimeCommandLine = runtimeCommandLine;
            this.cp = cp;
        }
    }
}

