/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.cds;

import com.alibaba.jvm.cds.CDSDataValidFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Classes4CDS {
    BufferedReader in;
    PrintStream out;
    static String tmpDir = "./tmp";
    static Classes4CDS instance = null;
    static HashMap<String, String> fatJarCache = new HashMap();
    boolean status = true;
    int p1 = 0;
    int p2 = 0;
    HashMap<String, String> idIds = new HashMap();
    HashMap<String, CDSData> nameidCDSData = new HashMap();
    Set<String> eagerCDSSet = new HashSet<String>();
    Set<String> appCDSSet = new HashSet<String>();
    Set<String> notFoundSet = new HashSet<String>();
    List<CDSData> all = new ArrayList<CDSData>();
    List<CDSData> allNotFound = new ArrayList<CDSData>();
    final Set<String> notFoundBlackList = new HashSet<String>(){
        {
            this.add("com/alibaba/china/mmc/business/order/render/redCoupon/MmcRedEnvelopeQueryParamAttach");
            this.add("com/alibaba/china/mmc/business/order/render/redCoupon/MmcRedEnvelopeSubmitParamAttach");
            this.add("com/alibaba/china/mmc/business/order/render/paysign/MmcPaySignQueryAttach");
            this.add("com/alibaba/china/mmc/business/order/render/promotion/MMCPromotionCOAttachQueryParamsSpi");
            this.add("com/alibaba/china/mmc/business/order/render/promotion/MMCPromotionCOAttachSubmitParamsSpi");
        }
    };
    Set<String> tempFiles = new HashSet<String>();

    public static Classes4CDS getInstance() {
        if (instance == null) {
            instance = new Classes4CDS();
        }
        return instance;
    }

    private Classes4CDS() {
    }

    private void mkdir(File dir) {
        if (!dir.exists()) {
            File parentDir = dir.getParentFile();
            if (!parentDir.exists()) {
                this.mkdir(parentDir);
            }
            dir.mkdir();
            this.tempFiles.add(dir.getAbsolutePath());
        }
    }

    private boolean extractFatJar(CDSData data, String mainJarName, String fatJarName) {
        String source = fatJarCache.get(fatJarName);
        if (source != null) {
            data.source = source;
            return true;
        }
        try {
            JarFile jar = new JarFile(mainJarName);
            ZipEntry ze = jar.getEntry(fatJarName);
            String tmpFile = tmpDir + "/" + fatJarName;
            if (ze != null) {
                int n;
                InputStream sin = jar.getInputStream(ze);
                File parent = new File(tmpFile).getParentFile();
                this.mkdir(parent);
                tmpFile = tmpDir + "/" + fatJarName;
                FileOutputStream output = new FileOutputStream(tmpFile);
                byte[] buff = new byte[4096];
                while ((n = sin.read(buff)) > 0) {
                    output.write(buff, 0, n);
                }
            } else {
                System.out.println("ZipEntry does not exist for " + fatJarName);
                return false;
            }
            data.source = tmpFile;
            fatJarCache.put(fatJarName, tmpFile);
            return true;
        }
        catch (IOException e) {
            System.out.println("Exception happened: " + e);
            return false;
        }
    }

    private boolean extractFileDir(CDSData data, String mainJarName, String path) throws Exception {
        int index;
        String outerPath = path;
        String dir = fatJarCache.get(path);
        if (dir != null) {
            return true;
        }
        String newName = data.className;
        String filePrePath = null;
        if (newName.contains("/")) {
            index = newName.length() - 1;
            while (newName.charAt(index) != '/') {
                --index;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            filePrePath = newName.substring(0, index + 1);
            newName = newName.substring(index + 1);
        } else if (newName.contains(".")) {
            index = newName.length() - 1;
            while (newName.charAt(index) != '.') {
                --index;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            filePrePath = newName.substring(0, index + 1);
            filePrePath = filePrePath.replace('.', '/');
            newName = newName.substring(index + 1);
        } else if (!path.endsWith("/")) {
            path = path + "/";
        }
        try {
            String tmpFile;
            String total;
            ZipEntry ze;
            JarFile jar = new JarFile(mainJarName);
            if (filePrePath != null) {
                path = path + filePrePath;
            }
            if ((ze = jar.getEntry(total = path + newName + ".class")) != null) {
                int n;
                InputStream input = jar.getInputStream(ze);
                File fdir = new File(tmpDir + "/" + path);
                this.mkdir(fdir);
                tmpFile = tmpDir + "/" + path + "/" + newName + ".class";
                FileOutputStream output = new FileOutputStream(tmpFile);
                byte[] buff = new byte[4096];
                while ((n = input.read(buff)) > 0) {
                    output.write(buff, 0, n);
                }
            } else {
                throw new Exception("ZipEntry does not exist for " + path + " ?");
            }
            fatJarCache.put(path, tmpFile);
            data.source = tmpDir + "/" + outerPath;
            return true;
        }
        catch (IOException e) {
            System.out.println("Exception happened: " + e);
            e.printStackTrace();
            throw e;
        }
    }

    public void setInputStream(BufferedReader input) {
        this.in = input;
    }

    public void setOutputStream(PrintStream prt) {
        this.out = prt;
    }

    public boolean succeeded() {
        return this.status;
    }

    private String getKlassName(String line) {
        int index = 0;
        while (line.charAt(index) != ' ') {
            ++index;
        }
        String name = line.substring(0, index);
        return name;
    }

    private String getOriginalSource(String line) {
        int index = line.indexOf("origin:");
        if (index == -1) {
            return null;
        }
        index += "origin:".length();
        while (line.charAt(index) == ' ') {
            ++index;
        }
        int start = index;
        while (line.charAt(index) != ' ') {
            ++index;
        }
        String path = line.substring(start, index);
        return path;
    }

    private String getKlassPath(String line) {
        int index = line.indexOf("source:");
        if (index == -1) {
            return null;
        }
        index += "source:".length();
        while (line.charAt(index) == ' ') {
            ++index;
        }
        int start = index;
        while (line.charAt(index) != ' ') {
            ++index;
        }
        String path = line.substring(start, index);
        return path;
    }

    private String getId(String line) throws Exception {
        int index = line.indexOf("klass: ");
        if (index == -1) {
            throw new Exception("no Id!");
        }
        index += "klass: ".length();
        while (line.charAt(index) == ' ') {
            ++index;
        }
        int start = index;
        while (index < line.length() && line.charAt(index) != ' ') {
            ++index;
        }
        String id = line.substring(start, index);
        return id.trim();
    }

    private String getSuperId(String line) {
        int index = line.indexOf("super: ");
        if (index == -1) {
            return null;
        }
        index += "super: ".length();
        while (line.charAt(index) == ' ') {
            ++index;
        }
        int start = index;
        while (index < line.length() && line.charAt(index) != ' ') {
            ++index;
        }
        String superId = line.substring(start, index);
        return superId;
    }

    private List<String> getInterfaces(String line) {
        String[] iids;
        String intfs;
        ArrayList<String> itfs = new ArrayList<String>();
        int index = line.indexOf("interfaces: ");
        if (index == -1) {
            return itfs;
        }
        index += "interfaces: ".length();
        while (line.charAt(index) == ' ') {
            ++index;
        }
        int i = index;
        while (i < line.length() && (i += 18) < line.length()) {
            while (line.charAt(i) == ' ') {
                ++i;
            }
            if (i + 1 < line.length() && line.charAt(i) == '0' && line.charAt(i + 1) == 'x') continue;
        }
        if (i == line.length()) {
            intfs = line.substring(index).trim();
        } else {
            try {
                intfs = line.substring(index, i).trim();
            }
            catch (Exception e) {
                System.out.println("error: " + line);
                throw new RuntimeException(e);
            }
        }
        for (String s : iids = intfs.split(" ")) {
            itfs.add(s);
        }
        return itfs;
    }

    private String getDefiningLoaderHash(String line) {
        int index = line.indexOf("defining_loader_hash: ");
        if (index == -1) {
            return null;
        }
        index += "defining_loader_hash: ".length();
        while (line.charAt(index) == ' ') {
            ++index;
        }
        int start = index;
        while (index < line.length() && line.charAt(index) != ' ') {
            ++index;
        }
        String hash = line.substring(start, index);
        return hash;
    }

    private String getInitiatingLoaderHash(String line) {
        int index = line.indexOf("initiating_loader_hash: ");
        if (index == -1) {
            return null;
        }
        index += "initiating_loader_hash: ".length();
        while (line.charAt(index) == ' ') {
            ++index;
        }
        int start = index;
        while (index < line.length() && line.charAt(index) != ' ') {
            ++index;
        }
        String hash = line.substring(start, index);
        return hash;
    }

    private String getFingerprint(String line) {
        int index = line.indexOf("fingerprint: ");
        if (index == -1) {
            return null;
        }
        index += "fingerprint: ".length();
        while (line.charAt(index) == ' ') {
            ++index;
        }
        int start = index;
        while (index < line.length() && line.charAt(index) != ' ') {
            ++index;
        }
        String name = line.substring(start, index);
        return name;
    }

    private String getOriginSource(String line) {
        return this.getValue(line, "origin: ");
    }

    private String getValue(String line, String key) {
        int index = line.indexOf(key);
        if (index == -1) {
            return null;
        }
        index += key.length();
        while (line.charAt(index) == ' ') {
            ++index;
        }
        int start = index;
        while (index < line.length() && line.charAt(index) != ' ') {
            ++index;
        }
        String name = line.substring(start, index);
        return name;
    }

    void printCDSData(CDSData data) {
        this.out.print(data.className);
        this.out.print(" ");
        this.out.print("id: " + data.id);
        this.out.print(" ");
        if (data.source != null && !data.source.contains("jrt:")) {
            if (data.superId != null) {
                this.out.print("super: " + data.superId);
                this.out.print(" ");
            }
            if (data.interfaceIds != null && data.interfaceIds.size() != 0) {
                this.out.print("interfaces: ");
                for (String s : data.interfaceIds) {
                    this.out.print(s);
                    this.out.print(" ");
                }
            }
            this.out.print("origin: " + data.originSource);
            this.out.print(" ");
            this.out.print("source: " + data.source);
            this.out.print(" ");
        } else {
            this.out.print("origin: " + data.originSource);
            this.out.print(" ");
        }
        if (data.initiatingHash != null) {
            this.out.print("initiating_loader_hash: " + data.initiatingHash);
            this.out.print(" ");
        } else if (data.definingHash != null) {
            this.out.print("initiating_loader_hash: " + data.definingHash);
            this.out.print(" ");
        }
        if (data.definingHash != null) {
            this.out.print("defining_loader_hash: " + data.definingHash);
            this.out.print(" ");
        }
        if (data.fingerprint != null) {
            this.out.print("fingerprint: " + data.fingerprint);
            this.out.print(" ");
        }
        this.out.println();
    }

    private void decodeSource(CDSData data) throws Exception {
        if (data.source == null) {
            return;
        }
        String source = data.source;
        int end = -1;
        int start = -1;
        boolean isFatJar = false;
        boolean isJarFile = false;
        boolean isFileDir = false;
        if (source.contains("jar:file:")) {
            String mainJarName;
            String[] jjs = source.split("!");
            if (jjs.length >= 2) {
                if (jjs[0].contains(".jar")) {
                    if (jjs[1].contains(".jar")) {
                        isFatJar = true;
                    } else if (jjs[1].length() == 1 && jjs[1].endsWith("/")) {
                        isJarFile = true;
                    } else {
                        isFileDir = true;
                    }
                } else {
                    throw new Exception("Cannot parse " + source);
                }
            }
            if (isJarFile) {
                start = source.indexOf("jar:file:");
                end = jjs[0].length() - 1;
                while (jjs[0].charAt(end) == '/') {
                    --end;
                }
                source = mainJarName = jjs[0].substring(start, end + 1);
                data.source = source = source.substring("jar:file:".length());
            }
            if (isFatJar) {
                mainJarName = jjs[0].substring("jar:file:".length());
                start = 0;
                end = jjs[1].length() - 1;
                while (jjs[1].charAt(start) == '/') {
                    ++start;
                }
                while (jjs[1].charAt(end) == '/' || jjs[1].charAt(end) == '!') {
                    --end;
                }
                String fatJarName = jjs[1].substring(start, end + 1);
                this.extractFatJar(data, mainJarName, fatJarName);
            }
            if (isFileDir) {
                mainJarName = jjs[0].substring("jar:file:".length());
                start = 0;
                end = jjs[1].length() - 1;
                while (jjs[1].charAt(end) == '/' || jjs[1].charAt(end) == '!') {
                    --end;
                }
                while (jjs[1].charAt(start) == '/') {
                    ++start;
                }
                String fileDir = jjs[1].substring(start, end + 1);
                this.extractFileDir(data, mainJarName, fileDir);
            }
        } else if (source.contains("file:")) {
            int index = source.indexOf("file:");
            index += "file:".length();
            while (source.charAt(index) == ' ') {
                ++index;
            }
            data.source = source.substring(index);
        }
    }

    private boolean invalidCheck(CDSData data) {
        if (data.source == null) {
            return false;
        }
        if (data.definingHash == null) {
            if (this.eagerCDSSet.contains(data.className) || this.appCDSSet.contains(data.className)) {
                return true;
            }
            this.appCDSSet.add(data.className);
        } else {
            if (this.appCDSSet.contains(data.className)) {
                return true;
            }
            this.eagerCDSSet.add(data.className);
        }
        return false;
    }

    void run() {
        String newId;
        int i;
        try {
            String line = this.in.readLine();
            while (!line.isEmpty()) {
                String id;
                String name;
                if (line.contains("defining_loader_hash:") && line.contains("initiating_loader_hash:")) {
                    name = this.getKlassName(line);
                    id = this.getId(line);
                    String definingHash = this.getDefiningLoaderHash(line);
                    String initiatingHash = this.getInitiatingLoaderHash(line);
                    CDSData oldData = this.nameidCDSData.get(name + id + definingHash);
                    if (oldData != null && oldData.initiatingHash == null) {
                        oldData.initiatingHash = initiatingHash;
                    }
                } else if (line.contains("source: not.found.class")) {
                    name = this.getKlassName(line);
                    if (!this.notFoundBlackList.contains(name)) {
                        String source = this.getKlassPath(line);
                        String initiatingHash = this.getInitiatingLoaderHash(line);
                        if (!this.notFoundSet.contains(name + initiatingHash)) {
                            CDSData newData = new CDSData(name, source, initiatingHash);
                            this.allNotFound.add(newData);
                            this.notFoundSet.add(name + initiatingHash);
                        }
                    }
                } else if (!line.contains("source: __JVM_DefineClass__")) {
                    name = this.getKlassName(line);
                    id = this.getId(line);
                    String originalSource = this.getOriginalSource(line);
                    String source = this.getKlassPath(line);
                    String superId = this.getSuperId(line);
                    List<String> iids = this.getInterfaces(line);
                    String definingHash = this.getDefiningLoaderHash(line);
                    String fingerprint = this.getFingerprint(line);
                    String originSource = this.getOriginSource(line);
                    CDSData newData = new CDSData(name, id, superId, iids, source, originSource, definingHash, fingerprint);
                    this.all.add(newData);
                    this.nameidCDSData.put(name + id + definingHash, newData);
                }
                if ((line = this.in.readLine()) != null) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status = false;
            return;
        }
        System.out.println("Total class load: " + this.all.size());
        int klassID = 1;
        CDSData data = this.all.get(0);
        if (!data.className.equals("java/lang/Object")) {
            System.out.println("First should be java/lang/Object!");
            this.status = false;
            return;
        }
        data.superId = null;
        this.idIds.put(data.id, "1");
        data.id = String.valueOf(klassID);
        try {
            this.decodeSource(data);
        }
        catch (Exception e) {
            System.out.println("Error happened, Exception is " + e);
            e.printStackTrace();
            this.status = false;
            return;
        }
        this.printCDSData(data);
        for (i = 1; i < this.all.size(); ++i) {
            boolean isvalid = true;
            data = this.all.get(i);
            if (this.invalidCheck(data)) {
                // empty if block
            }
            newId = String.valueOf(++klassID);
            this.idIds.put(data.id, newId);
            data.id = newId;
            if (data.superId != null) {
                String sp = this.idIds.get(data.superId);
                if (sp == null) {
                    isvalid = false;
                }
                data.superId = sp;
            }
            if (data.interfaceIds.size() != 0) {
                for (int j = 0; j < data.interfaceIds.size(); ++j) {
                    String intf = data.interfaceIds.get(j);
                    String iid = this.idIds.get(intf);
                    if (iid == null) {
                        isvalid = false;
                    }
                    data.interfaceIds.remove(j);
                    data.interfaceIds.add(j, iid);
                }
            }
            if (!isvalid) continue;
            try {
                this.decodeSource(data);
                Optional<String> invalid = CDSDataValidFactory.getInstance().isInvalid(data);
                if (invalid.isPresent()) {
                    System.out.println(invalid.get() + ",CDSData id: " + data.id + ",name: " + data.className);
                    continue;
                }
            }
            catch (Exception e) {
                System.out.println("Error happened, Exception is " + e);
                e.printStackTrace();
                this.status = false;
                return;
            }
            this.printCDSData(data);
        }
        for (i = 0; i < this.allNotFound.size(); ++i) {
            data = this.allNotFound.get(i);
            String name = data.className;
            if (this.appCDSSet.contains(name)) continue;
            data.id = newId = String.valueOf(++klassID);
            this.printCDSData(data);
        }
    }

    public static void main(String ... args) throws Exception {
        File f;
        if (args.length != 2 && args.length != 3) {
            Classes4CDS.printHelp();
        }
        if (!(f = new File(args[0])).exists()) {
            System.out.println("Non exists input file: " + args[0]);
            return;
        }
        if (args.length == 3) {
            File cachePath = new File(args[2]);
            if (!cachePath.exists()) {
                throw new FileNotFoundException("cache path error: " + cachePath);
            }
            tmpDir = cachePath.getAbsolutePath();
        }
        BufferedReader in = new BufferedReader(new FileReader(f));
        PrintWriter pw = new PrintWriter(args[1]);
        pw.close();
        PrintStream out = new PrintStream(args[1]);
        Classes4CDS cds = Classes4CDS.getInstance();
        cds.setInputStream(in);
        cds.setOutputStream(out);
        cds.run();
        if (cds.status) {
            System.out.println("Succeeded!");
        } else {
            System.out.println("Failed!");
        }
    }

    public static void printHelp() {
        System.out.println("Usage: ");
        System.out.println(" <input file> <output file>");
        System.exit(0);
    }

    public class CDSData {
        public String className;
        public String id;
        public String superId;
        public List<String> interfaceIds;
        public String originSource;
        public String source;
        public String definingHash;
        public String initiatingHash;
        public String fingerprint;

        public CDSData(String name, String id, String superId, List<String> iids, String sourcePath, String originSource, String definingHash, String fingerprint) {
            this.className = name;
            this.id = id;
            this.superId = superId;
            this.interfaceIds = iids;
            this.source = sourcePath;
            this.originSource = originSource;
            this.definingHash = definingHash;
            this.initiatingHash = null;
            this.fingerprint = fingerprint;
        }

        public CDSData(String name, String sourcePath, String initiatingHash) {
            this.className = name;
            this.id = null;
            this.superId = null;
            this.interfaceIds = null;
            this.source = sourcePath;
            this.definingHash = null;
            this.initiatingHash = initiatingHash;
            this.fingerprint = null;
        }
    }
}

