/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.util.classnames;

import com.alibaba.jvm.util.AJDKUtils;
import com.alibaba.jvm.util.classnames.LineNumberHandler;
import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl;
import com.sun.org.apache.xerces.internal.jaxp.SAXParserImpl;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class ClassLoaderXMLParser {
    static String xmlPath;
    static boolean specialSingleClassLoaderMode;
    private static final int MAXIMUM_FILE_SIZE = 0x100000;
    protected static Map<String, ClassLoaderNameConfig> configs;
    private static boolean PARSED;

    ClassLoaderXMLParser() {
    }

    private static String readContent(Reader r) throws IOException {
        int ch;
        CharArrayWriter writer = new CharArrayWriter(1024);
        int count = 0;
        while ((ch = r.read()) != -1) {
            writer.write(ch);
            if (++count < 0x100000) continue;
            throw new IOException("Presets with more than 1048576 characters can't be read.");
        }
        return new String(writer.toCharArray());
    }

    protected static void parse() throws Exception {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        SAXParserImpl parser = (SAXParserImpl)factory.newSAXParser();
        DocumentBuilderFactoryImpl docBuilderFactory = new DocumentBuilderFactoryImpl();
        DocumentBuilder docBuilder = ((DocumentBuilderFactory)docBuilderFactory).newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        LineNumberHandler handler = new LineNumberHandler(doc);
        InputStream is = xmlPath == null ? ClassLoaderXMLParser.class.getResourceAsStream("/classloader-config.xml") : new FileInputStream(xmlPath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        CharArrayReader r = new CharArrayReader(ClassLoaderXMLParser.readContent(reader).toCharArray());
        parser.parse(new InputSource(r), (DefaultHandler)handler);
        NodeList classloaders = doc.getElementsByTagName("classloader");
        for (int i = 0; i < classloaders.getLength(); ++i) {
            Node loader = classloaders.item(i);
            NodeList elems = loader.getChildNodes();
            String klass = null;
            String fieldName = null;
            boolean appendJarPathsAsName = false;
            String uniqueName = null;
            for (int j = 0; j < elems.getLength(); ++j) {
                Node loaderInner = elems.item(j);
                if (loaderInner.getNodeType() != 1 || loaderInner.getFirstChild() == null) continue;
                if ("klass".equals(loaderInner.getNodeName())) {
                    klass = loaderInner.getFirstChild().getNodeValue();
                    continue;
                }
                if ("fieldName".equals(loaderInner.getNodeName())) {
                    fieldName = loaderInner.getFirstChild().getNodeValue();
                    continue;
                }
                if ("appendJarPathsAsName".equals(loaderInner.getNodeName())) {
                    appendJarPathsAsName = Boolean.parseBoolean(loaderInner.getFirstChild().getNodeValue());
                    continue;
                }
                if (!"uniqueName".equals(loaderInner.getNodeName())) continue;
                uniqueName = loaderInner.getFirstChild().getNodeValue();
            }
            if (klass == null) {
                throw new NullPointerException("klass shouldn't be null: line " + loader.getUserData("lineNumber"));
            }
            if (fieldName == null && !appendJarPathsAsName && uniqueName == null) {
                throw new NullPointerException("klass " + klass + " has no name specified, please check");
            }
            ClassLoaderNameConfig cfg = configs.put(klass, new ClassLoaderNameConfig(fieldName, appendJarPathsAsName, uniqueName));
            if (cfg == null) continue;
            throw new IllegalArgumentException("klass " + klass + " should only have one <classloader> element!");
        }
    }

    private static String getJarPathsAsClassLoaderName(URLClassLoader u) {
        URL[] urls = u.getURLs();
        List urlList = Arrays.stream(urls).filter(url -> url.getPath().endsWith("jar")).map(URL::getPath).sorted().collect(Collectors.toList());
        StringBuffer buffer = new StringBuffer();
        buffer.append(u.getClass().getName()).append("@");
        for (String s : urlList) {
            buffer.append(s);
        }
        return buffer.toString();
    }

    private static String generateIdentifier(ClassLoader loader) throws Exception {
        String klassName;
        ClassLoaderNameConfig cfg;
        if (!PARSED) {
            ClassLoaderXMLParser.parse();
            PARSED = true;
        }
        if ((cfg = configs.get(klassName = loader.getClass().getName())) == null) {
            return null;
        }
        boolean appendJarPathsAsName = cfg.isAppendJarPathsAsName();
        String fieldName = cfg.getFieldName();
        String uniqueName = cfg.getUniqueName();
        StringBuilder sb = new StringBuilder();
        sb.append(klassName);
        if (appendJarPathsAsName) {
            if (!URLClassLoader.class.isAssignableFrom(loader.getClass())) {
                if (fieldName == null && uniqueName == null) {
                    throw new NullPointerException("klass " + loader + " cannot appendJarPathsAsName because it's not an URLClassLoader!");
                }
            } else {
                sb.append("@").append(ClassLoaderXMLParser.getJarPathsAsClassLoaderName((URLClassLoader)loader));
            }
        }
        if (fieldName != null) {
            Field f = loader.getClass().getDeclaredField(fieldName);
            if (f.getType() != String.class) {
                System.err.println("[Warning] ClassLoader registering: klass " + loader + "'s <fieldName> field should be a java.lang.String type currently. Now using toString()");
            }
            f.setAccessible(true);
            Object targetFieldValue = f.get(loader);
            f.setAccessible(false);
            sb.append("@").append(targetFieldValue);
        }
        if (uniqueName != null) {
            sb.append("@").append(uniqueName);
        }
        String name = sb.toString();
        return name;
    }

    public static void registerClassLoader(ClassLoader loader) throws Exception {
        String identifier = ClassLoaderXMLParser.generateIdentifier(loader);
        if (identifier != null) {
            try {
                AJDKUtils.registerClassLoader.invoke(null, loader, identifier);
                System.out.println("[Name] Register [" + loader + "] as [" + identifier + "]: hash [" + Integer.toHexString((Integer)AJDKUtils.calculateSignatureForName.invoke(null, identifier)) + "] " + (!specialSingleClassLoaderMode ? "(normal mode)" : "(single loader mode)"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        String singleLoadMode;
        Properties p = AccessController.doPrivileged(System::getProperties);
        xmlPath = p.getProperty("com.alibaba.util.xmlconfig");
        if (xmlPath != null && !new File(xmlPath).isFile()) {
            System.err.println("[Warning] Invalid xmlconfig path: " + xmlPath + ". Use the default configuration instead.");
            xmlPath = null;
        }
        if ((singleLoadMode = p.getProperty("com.alibaba.quickstart.singleLoaderMode")) != null && singleLoadMode.equalsIgnoreCase("true")) {
            specialSingleClassLoaderMode = true;
        }
        configs = new HashMap<String, ClassLoaderNameConfig>();
        PARSED = false;
    }

    static class ClassLoaderNameConfig {
        private String fieldName;
        private boolean appendJarPathsAsName;
        private String uniqueName;

        public ClassLoaderNameConfig(String field, boolean appendJarPathsAsName, String uniqueName) {
            this.fieldName = field;
            this.appendJarPathsAsName = appendJarPathsAsName;
            this.uniqueName = uniqueName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public boolean isAppendJarPathsAsName() {
            return this.appendJarPathsAsName;
        }

        public void setAppendJarPathsAsName(boolean appendJarPathsAsName) {
            this.appendJarPathsAsName = appendJarPathsAsName;
        }

        public String getUniqueName() {
            return this.uniqueName;
        }

        public void setUniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
        }
    }
}

