/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.rdma;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.SharedSecrets;
import sun.net.ext.RdmaSocketOptions;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.IOUtilAccess;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.NetAccess;
import sun.nio.ch.RdmaSocketDispatcher;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.rdma.RdmaNet;
import sun.nio.ch.rdma.RdmaSocketAdaptor;

public class RdmaSocketChannelImpl
extends SocketChannel
implements SelChImpl {
    private final ProtocolFamily family;
    private static RdmaSocketDispatcher nd;
    private final FileDescriptor fd;
    private final int fdVal;
    private final ReentrantLock readLock = new ReentrantLock();
    private final ReentrantLock writeLock = new ReentrantLock();
    private final Object stateLock = new Object();
    private volatile boolean isInputClosed;
    private volatile boolean isOutputClosed;
    private boolean isReuseAddress;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_CONNECTIONPENDING = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_CLOSING = 3;
    private static final int ST_KILLPENDING = 4;
    private static final int ST_KILLED = 5;
    private volatile int state;
    private long readerThread;
    private long writerThread;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private Socket socket;
    private static final UnsupportedOperationException unsupported;
    private static final IOUtilAccess IO_UTIL_ACCESS;
    private static final NetAccess NET_ACCESS;

    private static final SelectorProvider checkSupported(SelectorProvider selectorProvider) {
        if (unsupported != null) {
            throw new UnsupportedOperationException(unsupported.getMessage(), unsupported);
        }
        return selectorProvider;
    }

    protected RdmaSocketChannelImpl(SelectorProvider selectorProvider, ProtocolFamily protocolFamily) throws IOException {
        super(RdmaSocketChannelImpl.checkSupported(selectorProvider));
        Objects.requireNonNull(protocolFamily, "null family");
        if (protocolFamily != StandardProtocolFamily.INET && protocolFamily != StandardProtocolFamily.INET6) {
            throw new UnsupportedOperationException("Protocol family not supported");
        }
        if (protocolFamily == StandardProtocolFamily.INET6 && !NET_ACCESS.isIPv6Available()) {
            throw new UnsupportedOperationException("IPv6 not available");
        }
        this.family = protocolFamily;
        this.fd = RdmaNet.socket(protocolFamily, true);
        IOUtil.configureBlocking(this.fd, false);
        this.fdVal = IOUtil.fdVal(this.fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RdmaSocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
        super(RdmaSocketChannelImpl.checkSupported(selectorProvider));
        this.family = NET_ACCESS.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        IOUtil.configureBlocking(fileDescriptor, false);
        Object object = this.stateLock;
        synchronized (object) {
            this.localAddress = RdmaNet.localAddress(fileDescriptor);
            this.remoteAddress = inetSocketAddress;
            this.state = 2;
        }
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void ensureOpenAndConnected() throws ClosedChannelException {
        int n = this.state;
        if (n < 2) {
            throw new NotYetConnectedException();
        }
        if (n > 2) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = RdmaSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            return NET_ACCESS.getRevealedLocalAddress(this.localAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        Objects.requireNonNull(socketOption);
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            RdmaNet.setSocketOption(this.fd, RdmaNet.UNSPEC, socketOption, t);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        Objects.requireNonNull(socketOption);
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            return (T)RdmaNet.getSocketOption(this.fd, RdmaNet.UNSPEC, socketOption);
        }
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginRead(boolean bl) throws ClosedChannelException {
        if (bl) {
            this.begin();
            Object object = this.stateLock;
            synchronized (object) {
                this.ensureOpenAndConnected();
                this.readerThread = NativeThread.current();
            }
        } else {
            this.ensureOpenAndConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRead(boolean bl, boolean bl2) throws AsynchronousCloseException {
        if (bl) {
            Object object = this.stateLock;
            synchronized (object) {
                this.readerThread = 0L;
                if (this.state == 3) {
                    this.stateLock.notifyAll();
                }
            }
            this.end(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        Objects.requireNonNull(byteBuffer);
        this.readLock.lock();
        try {
            int n;
            boolean bl;
            block13: {
                bl = this.isBlocking();
                n = 0;
                this.beginRead(bl);
                if (!this.isInputClosed) break block13;
                int n2 = -1;
                this.endRead(bl, n > 0);
                if (n <= 0 && this.isInputClosed) {
                    int n3 = -1;
                    return n3;
                }
                return n2;
            }
            try {
                n = IO_UTIL_ACCESS.read(this.fd, byteBuffer, -1L, nd);
                if (n == -2 && bl) {
                    do {
                        RdmaNet.poll(this.fd, Net.POLLIN, -1L);
                    } while ((n = IO_UTIL_ACCESS.read(this.fd, byteBuffer, -1L, nd)) == -2 && this.isOpen());
                }
                this.endRead(bl, n > 0);
            }
            catch (Throwable throwable) {
                block14: {
                    this.endRead(bl, n > 0);
                    if (n > 0 || !this.isInputClosed) break block14;
                    int n4 = -1;
                    this.readLock.unlock();
                    return n4;
                }
                throw throwable;
            }
            if (n <= 0 && this.isInputClosed) {
                int n5 = -1;
                return n5;
            }
            int n6 = IOStatus.normalize(n);
            return n6;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        this.readLock.lock();
        try {
            long l;
            boolean bl;
            block13: {
                bl = this.isBlocking();
                l = 0L;
                this.beginRead(bl);
                if (!this.isInputClosed) break block13;
                long l2 = -1L;
                this.endRead(bl, l > 0L);
                if (l <= 0L && this.isInputClosed) {
                    long l3 = -1L;
                    return l3;
                }
                return l2;
            }
            try {
                l = IO_UTIL_ACCESS.read(this.fd, byteBufferArray, n, n2, nd);
                if (l == -2L && bl) {
                    do {
                        RdmaNet.poll(this.fd, Net.POLLIN, -1L);
                    } while ((l = IO_UTIL_ACCESS.read(this.fd, byteBufferArray, n, n2, nd)) == -2L && this.isOpen());
                }
                this.endRead(bl, l > 0L);
            }
            catch (Throwable throwable) {
                block14: {
                    this.endRead(bl, l > 0L);
                    if (l > 0L || !this.isInputClosed) break block14;
                    long l4 = -1L;
                    this.readLock.unlock();
                    return l4;
                }
                throw throwable;
            }
            if (l <= 0L && this.isInputClosed) {
                long l5 = -1L;
                return l5;
            }
            long l6 = IOStatus.normalize(l);
            return l6;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginWrite(boolean bl) throws ClosedChannelException {
        if (bl) {
            this.begin();
            Object object = this.stateLock;
            synchronized (object) {
                this.ensureOpenAndConnected();
                if (this.isOutputClosed) {
                    throw new ClosedChannelException();
                }
                this.writerThread = NativeThread.current();
            }
        } else {
            this.ensureOpenAndConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endWrite(boolean bl, boolean bl2) throws AsynchronousCloseException {
        if (bl) {
            Object object = this.stateLock;
            synchronized (object) {
                this.writerThread = 0L;
                if (this.state == 3) {
                    this.stateLock.notifyAll();
                }
            }
            this.end(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        Objects.requireNonNull(byteBuffer);
        this.writeLock.lock();
        try {
            boolean bl = this.isBlocking();
            int n = 0;
            try {
                this.beginWrite(bl);
                n = IO_UTIL_ACCESS.write(this.fd, byteBuffer, -1L, nd);
                if (n == -2 && bl) {
                    do {
                        RdmaNet.poll(this.fd, Net.POLLOUT, -1L);
                    } while ((n = IO_UTIL_ACCESS.write(this.fd, byteBuffer, -1L, nd)) == -2 && this.isOpen());
                }
                this.endWrite(bl, n > 0);
            }
            catch (Throwable throwable) {
                this.endWrite(bl, n > 0);
                if (n <= 0 && this.isOutputClosed) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            if (n <= 0 && this.isOutputClosed) {
                throw new AsynchronousCloseException();
            }
            int n2 = IOStatus.normalize(n);
            return n2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        this.writeLock.lock();
        try {
            boolean bl = this.isBlocking();
            long l = 0L;
            try {
                this.beginWrite(bl);
                l = IO_UTIL_ACCESS.write(this.fd, byteBufferArray, n, n2, nd);
                if (l == -2L && bl) {
                    do {
                        RdmaNet.poll(this.fd, Net.POLLOUT, -1L);
                    } while ((l = IO_UTIL_ACCESS.write(this.fd, byteBufferArray, n, n2, nd)) == -2L && this.isOpen());
                }
                this.endWrite(bl, l > 0L);
            }
            catch (Throwable throwable) {
                this.endWrite(bl, l > 0L);
                if (l <= 0L && this.isOutputClosed) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            if (l <= 0L && this.isOutputClosed) {
                throw new AsynchronousCloseException();
            }
            long l2 = IOStatus.normalize(l);
            return l2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendOutOfBandData(byte by) throws IOException {
        this.writeLock.lock();
        try {
            boolean bl = this.isBlocking();
            int n = 0;
            try {
                this.beginWrite(bl);
                n = RdmaSocketChannelImpl.sendOutOfBandData(this.fd, by);
                if (n == -2 && bl) {
                    do {
                        RdmaNet.poll(this.fd, Net.POLLOUT, -1L);
                    } while ((n = RdmaSocketChannelImpl.sendOutOfBandData(this.fd, by)) == -3 && this.isOpen());
                }
                this.endWrite(bl, n > 0);
            }
            catch (Throwable throwable) {
                this.endWrite(bl, n > 0);
                if (n <= 0 && this.isOutputClosed) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            if (n <= 0 && this.isOutputClosed) {
                throw new AsynchronousCloseException();
            }
            int n2 = IOStatus.normalize(n);
            return n2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    this.ensureOpen();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetSocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetSocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    private final InetSocketAddress anyLocalAddress() throws IOException {
        if (this.family == StandardProtocolFamily.INET) {
            return new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0);
        }
        if (this.family == StandardProtocolFamily.INET6) {
            return new InetSocketAddress(InetAddress.getByName("::"), 0);
        }
        throw new UnsupportedAddressTypeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    this.ensureOpen();
                    if (this.state == 1) {
                        throw new ConnectionPendingException();
                    }
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = socketAddress == null ? this.anyLocalAddress() : RdmaNet.checkAddress(socketAddress, this.family);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkListen(inetSocketAddress.getPort());
                    }
                    RdmaNet.bind(this.family, this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = RdmaNet.localAddress(this.fd);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this;
    }

    @Override
    public boolean isConnected() {
        return this.state == 2;
    }

    @Override
    public boolean isConnectionPending() {
        return this.state == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginConnect(boolean bl, InetSocketAddress inetSocketAddress) throws IOException {
        if (bl) {
            this.begin();
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            int n = this.state;
            if (n == 2) {
                throw new AlreadyConnectedException();
            }
            if (n == 1) {
                throw new ConnectionPendingException();
            }
            assert (n == 0);
            this.state = 1;
            this.remoteAddress = inetSocketAddress;
            if (bl) {
                this.readerThread = NativeThread.current();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endConnect(boolean bl, boolean bl2) throws IOException {
        this.endRead(bl, bl2);
        if (bl2) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 1) {
                    this.localAddress = RdmaNet.localAddress(this.fd);
                    this.state = 2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        InetAddress inetAddress;
        InetSocketAddress inetSocketAddress = RdmaNet.checkAddress(socketAddress, this.family);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
        }
        if ((inetAddress = inetSocketAddress.getAddress()).isAnyLocalAddress()) {
            inetAddress = InetAddress.getLocalHost();
        }
        try {
            this.readLock.lock();
            try {
                this.writeLock.lock();
                try {
                    boolean bl;
                    boolean bl2 = this.isBlocking();
                    boolean bl3 = false;
                    try {
                        this.beginConnect(bl2, inetSocketAddress);
                        bl = RdmaNet.connect(this.family, this.fd, inetAddress, inetSocketAddress.getPort());
                        if (bl && bl2) {
                            do {
                                RdmaNet.poll(this.fd, Net.POLLOUT, -1L);
                            } while ((bl = RdmaSocketChannelImpl.checkConnect(this.fd, false)) && this.isOpen());
                        }
                        bl3 = bl > false && this.isOpen();
                    }
                    finally {
                        this.endConnect(bl2, bl3);
                    }
                    bl = bl3;
                    this.writeLock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginFinishConnect(boolean bl) throws ClosedChannelException {
        if (bl) {
            this.begin();
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.state != 1) {
                throw new NoConnectionPendingException();
            }
            if (bl) {
                this.readerThread = NativeThread.current();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endFinishConnect(boolean bl, boolean bl2) throws IOException {
        this.endRead(bl, bl2);
        if (bl2) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 1) {
                    this.localAddress = RdmaNet.localAddress(this.fd);
                    this.state = 2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean finishConnect() throws IOException {
        try {
            this.readLock.lock();
            try {
                block16: {
                    this.writeLock.lock();
                    if (!this.isConnected()) break block16;
                    boolean bl = true;
                    this.writeLock.unlock();
                    return bl;
                }
                try {
                    boolean bl;
                    boolean bl2 = this.isBlocking();
                    boolean bl3 = false;
                    try {
                        this.beginFinishConnect(bl2);
                        bl = RdmaSocketChannelImpl.checkConnect(this.fd, false);
                        if (bl && bl2) {
                            do {
                                RdmaNet.poll(this.fd, Net.POLLOUT, -1L);
                            } while ((bl = RdmaSocketChannelImpl.checkConnect(this.fd, false)) && this.isOpen());
                        }
                        bl3 = bl > false && this.isOpen();
                    }
                    finally {
                        this.endFinishConnect(bl2, bl3);
                    }
                    assert ((bl2 && bl3) ^ !bl2);
                    bl = bl3;
                    this.writeLock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        boolean bl;
        boolean bl2;
        assert (!this.isOpen());
        boolean bl3 = false;
        Object object = this.stateLock;
        synchronized (object) {
            assert (this.state < 3);
            bl2 = this.isBlocking();
            bl = this.state == 2;
            this.state = 3;
        }
        if (bl2) {
            object = this.stateLock;
            synchronized (object) {
                assert (this.state == 3);
                long l = this.readerThread;
                long l2 = this.writerThread;
                if (l != 0L || l2 != 0L) {
                    nd.preClose(this.fd);
                    bl = false;
                    if (l != 0L) {
                        NativeThread.signal(l);
                    }
                    if (l2 != 0L) {
                        NativeThread.signal(l2);
                    }
                    while (this.readerThread != 0L || this.writerThread != 0L) {
                        try {
                            this.stateLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl3 = true;
                        }
                    }
                }
            }
        }
        this.readLock.lock();
        try {
            this.writeLock.lock();
            this.writeLock.unlock();
        }
        finally {
            this.readLock.unlock();
        }
        object = this.stateLock;
        synchronized (object) {
            assert (this.state == 3);
            if (bl && this.isRegistered()) {
                try {
                    RdmaNet.shutdown(this.fd, 1);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.state = 4;
        }
        if (!this.isRegistered()) {
            this.kill();
        }
        if (bl3) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 4) {
                this.state = 5;
                nd.rdmaClose(this.fd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownInput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (!this.isInputClosed) {
                RdmaNet.shutdown(this.fd, 0);
                long l = this.readerThread;
                if (l != 0L) {
                    NativeThread.signal(l);
                }
                this.isInputClosed = true;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownOutput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (!this.isOutputClosed) {
                RdmaNet.shutdown(this.fd, 1);
                long l = this.writerThread;
                if (l != 0L) {
                    NativeThread.signal(l);
                }
                this.isOutputClosed = true;
            }
            return this;
        }
    }

    boolean isInputOpen() {
        return !this.isInputClosed;
    }

    boolean isOutputOpen() {
        return !this.isOutputClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pollRead(long l) throws IOException {
        boolean bl = this.isBlocking();
        assert (Thread.holdsLock(this.blockingLock()) && bl);
        this.readLock.lock();
        try {
            boolean bl3 = false;
            try {
                this.beginRead(bl);
                int bl2 = RdmaNet.poll(this.fd, Net.POLLIN, l);
                bl3 = bl2 != 0;
            }
            finally {
                this.endRead(bl, bl3);
            }
            boolean bl2 = bl3;
            return bl2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pollConnected(long l) throws IOException {
        boolean bl = this.isBlocking();
        assert (Thread.holdsLock(this.blockingLock()) && bl);
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                boolean bl3 = false;
                try {
                    this.beginFinishConnect(bl);
                    int bl2 = RdmaNet.poll(this.fd, Net.POLLCONN, l);
                    bl3 = bl2 != 0;
                }
                finally {
                    this.endFinishConnect(bl, false);
                }
                boolean bl2 = bl3;
                this.writeLock.unlock();
                return bl2;
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((n & (Net.POLLERR | Net.POLLHUP)) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            return (n5 & ~n4) != 0;
        }
        boolean bl = this.isConnected();
        if ((n & Net.POLLIN) != 0 && (n3 & 1) != 0 && bl) {
            n5 |= 1;
        }
        if ((n & Net.POLLCONN) != 0 && (n3 & 8) != 0 && this.isConnectionPending()) {
            n5 |= 8;
        }
        if ((n & Net.POLLOUT) != 0 && (n3 & 4) != 0 && bl) {
            n5 |= 4;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    public int translateInterestOps(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= Net.POLLIN;
        }
        if ((n & 4) != 0) {
            n2 |= Net.POLLOUT;
        }
        if ((n & 8) != 0) {
            n2 |= Net.POLLCONN;
        }
        return n2;
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSuperclass().getName());
        stringBuilder.append('[');
        if (!this.isOpen()) {
            stringBuilder.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case 0: {
                        stringBuilder.append("unconnected");
                        break;
                    }
                    case 1: {
                        stringBuilder.append("connection-pending");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("connected");
                        if (this.isInputClosed) {
                            stringBuilder.append(" ishut");
                        }
                        if (!this.isOutputClosed) break;
                        stringBuilder.append(" oshut");
                    }
                }
                InetSocketAddress inetSocketAddress = this.localAddress();
                if (inetSocketAddress != null) {
                    stringBuilder.append(" local=");
                    stringBuilder.append(NET_ACCESS.getRevealedLocalAddressAsString(inetSocketAddress));
                }
                if (this.remoteAddress() != null) {
                    stringBuilder.append(" remote=");
                    stringBuilder.append(this.remoteAddress().toString());
                }
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= Net.POLLIN;
        }
        if ((n & 4) != 0) {
            n2 |= Net.POLLOUT;
        }
        if ((n & 8) != 0) {
            n2 |= Net.POLLCONN;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    private static native void initIDs() throws UnsupportedOperationException;

    private static native int checkConnect(FileDescriptor var0, boolean var1) throws IOException;

    private static native int sendOutOfBandData(FileDescriptor var0, byte var1) throws IOException;

    static {
        IO_UTIL_ACCESS = SharedSecrets.getIoUtilAccess();
        NET_ACCESS = SharedSecrets.getNetAccess();
        IOUtil.load();
        System.loadLibrary("extnet");
        UnsupportedOperationException unsupportedOperationException = null;
        try {
            RdmaSocketChannelImpl.initIDs();
        }
        catch (UnsupportedOperationException unsupportedOperationException2) {
            unsupportedOperationException = unsupportedOperationException2;
        }
        unsupported = unsupportedOperationException;
        nd = new RdmaSocketDispatcher();
    }

    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet hashSet = new HashSet();
            hashSet.add(StandardSocketOptions.SO_SNDBUF);
            hashSet.add(StandardSocketOptions.SO_RCVBUF);
            hashSet.add(StandardSocketOptions.SO_REUSEADDR);
            hashSet.add(StandardSocketOptions.TCP_NODELAY);
            RdmaSocketOptions rdmaSocketOptions = RdmaSocketOptions.getInstance();
            hashSet.addAll(rdmaSocketOptions.options());
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

