/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.zip.CRC32;

public class Utils {
    public static final String JAVA_COMMAND_LINE_SPLITTER = "(?<!\\\\)[\r\t ]";
    public static final String JAVA_TOOL_OPTIONS = "JAVA_TOOL_OPTIONS";
    public static final int NO_TIMEOUT = -1;
    private static File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");

    public static void printArgs(List<String> arguments, String msg, boolean verbose) {
        Utils.printArgs(arguments, msg, verbose, System.out);
    }

    public static void printArgs(List<String> arguments, String msg, boolean verbose, File existedFile) {
        try (PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(existedFile)), true);){
            Utils.printArgs(arguments, msg, verbose, ps);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void printArgs(List<String> arguments, String msg, boolean verbose, PrintStream ps) {
        if (!verbose) {
            return;
        }
        ps.print(msg);
        for (String s : arguments) {
            ps.print(s + " ");
        }
        ps.println();
    }

    public static String removeAgentOp() {
        String toolOp = System.getenv(JAVA_TOOL_OPTIONS);
        return toolOp == null ? null : toolOp.replaceAll("-javaagent\\S*\\s?", " ");
    }

    private static void readProcessOutputWithThread(Process p, File f) {
        new Thread(() -> {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));){
                while (true) {
                    String line;
                    if ((line = br.readLine()) != null) {
                        System.out.println(line);
                    }
                    if (!p.isAlive()) {
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFile(File f) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append(System.lineSeparator());
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static void runProcess(List<String> arguments, boolean verbose, Consumer<ProcessBuilder> op, TimeOut timeout, LogInfo log) throws Exception {
        boolean hasError;
        File logFile;
        ProcessBuilder pb = new ProcessBuilder(arguments).inheritIO();
        if (op != null) {
            op.accept(pb);
        }
        if (!log.logDir.toFile().exists()) {
            log.logDir.toFile().mkdirs();
        }
        if (!(logFile = log.logDir.resolve(log.logName).toFile()).exists()) {
            logFile.createNewFile();
        }
        Utils.printArgs(arguments, "[Command] ", verbose, logFile);
        if (verbose) {
            pb.redirectOutput(ProcessBuilder.Redirect.appendTo(logFile));
            pb.redirectErrorStream(true);
        } else {
            pb.redirectOutput(NULL_FILE);
            pb.redirectError(ProcessBuilder.Redirect.appendTo(logFile));
        }
        Process p = pb.start();
        if (verbose) {
            Utils.readProcessOutputWithThread(p, logFile);
        }
        int ret = 0;
        if (timeout != null && !timeout.noTimeOut()) {
            if (!p.waitFor(timeout.timeout, timeout.timeUnit)) {
                p.destroyForcibly();
                throw new TimeoutException("[Fatal] Process timed out");
            }
        } else {
            ret = p.waitFor();
        }
        if ((hasError = ret != 0) || verbose) {
            System.out.println("return value: " + ret);
            if (hasError) {
                throw new Exception("Process failed: { " + Utils.readFile(logFile) + " }");
            }
        }
    }

    public static void runProcess(boolean verbose, String msg, LogInfo logInfo, String ... args) {
        List<String> command = Arrays.asList(args);
        Utils.printArgs(command, msg, verbose);
        try {
            Utils.runProcess(command, verbose, null, null, logInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static String getJDKHome() {
        String jdkHome = System.getProperty("java.home");
        if (!new File(jdkHome).exists()) {
            throw new Error("Fatal error, cannot find jdk path: [" + jdkHome + "] doesn't exist!");
        }
        return jdkHome;
    }

    public static List<String> readPlainText(String filePath) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String line = br.readLine();
            while (line != null) {
                lines.add(line);
                line = br.readLine();
            }
        }
        return lines;
    }

    public static void log(String format, String ... args) {
        System.out.println("[" + new Date() + "]" + String.format(format, args));
    }

    public static String fingerprint(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        long count = IOUtils.copy(input, output);
        byte[] bytes = output.toByteArray();
        return Utils.fingerprint(bytes, count);
    }

    public static String fingerprint(byte[] bytes, long count) throws IOException {
        CRC32 crc = new CRC32();
        crc.update(bytes);
        long v = count << 32 | crc.getValue();
        return String.format("0x%016x", v);
    }

    public static class IOUtils {
        public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
            return IOUtils.copyLarge(input, output, new byte[bufferSize]);
        }

        public static long copy(InputStream input, OutputStream output) throws IOException {
            return IOUtils.copy(input, output, 4096);
        }

        public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
            int n;
            long count = 0L;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            return count;
        }

        public static void copyToFile(InputStream source, File destination) throws IOException {
            try (InputStream in = source;
                 FileOutputStream out = new FileOutputStream(destination);){
                IOUtils.copy(in, out);
            }
        }
    }

    public static class LogInfo {
        private Path logDir;
        private String logName;

        public LogInfo() {
        }

        public LogInfo(Path logDir, String logName) {
            this.logDir = logDir;
            this.logName = logName;
        }
    }

    public static class TimeOut {
        public int timeout = -1;
        public TimeUnit timeUnit = TimeUnit.HOURS;

        public TimeOut() {
        }

        public TimeOut(int timeout, TimeUnit timeUnit) {
            this.timeout = timeout;
            this.timeUnit = timeUnit;
        }

        public boolean noTimeOut() {
            return this.timeout == -1;
        }
    }
}

