/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.wisp.engine.WispCarrier;
import com.alibaba.wisp.engine.WispConfiguration;
import com.alibaba.wisp.engine.WispEngine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.UnsafeAccess;

final class WispSysmon
extends Enum<WispSysmon> {
    public static final /* enum */ WispSysmon INSTANCE = new WispSysmon();
    private final Set<WispCarrier> carriers = new ConcurrentSkipListSet<WispCarrier>();
    static final String WISP_SYSMON_NAME = "Wisp-Sysmon";
    private final List<WispCarrier> longOccupationEngines = new ArrayList<WispCarrier>();
    private static final UnsafeAccess UA;
    private static final JavaLangAccess JLA;
    private static final /* synthetic */ WispSysmon[] $VALUES;

    public static WispSysmon[] values() {
        return (WispSysmon[])$VALUES.clone();
    }

    public static WispSysmon valueOf(String string) {
        return Enum.valueOf(WispSysmon.class, string);
    }

    void startDaemon() {
        if (WispConfiguration.ENABLE_HANDOFF) {
            assert (WispConfiguration.HANDOFF_POLICY != null);
            Thread thread = new Thread(WispEngine.DAEMON_THREAD_GROUP, INSTANCE::sysmonLoop, WISP_SYSMON_NAME);
            thread.setDaemon(true);
            thread.start();
        }
    }

    void register(WispCarrier wispCarrier) {
        if (WispConfiguration.ENABLE_HANDOFF) {
            this.carriers.add(wispCarrier);
        }
    }

    private void sysmonLoop() {
        long l = TimeUnit.MICROSECONDS.toNanos(WispConfiguration.SYSMON_TICK_US);
        long l2 = TimeUnit.MICROSECONDS.toNanos(WispConfiguration.SYSMON_CARRIER_GROW_TICK_US);
        long l3 = l2 / l;
        boolean bl = WispConfiguration.CARRIER_GROW && l3 > 0L && WispConfiguration.WORKER_COUNT == Runtime.getRuntime().availableProcessors();
        long l4 = System.nanoTime() + l;
        int n = 0;
        while (true) {
            long l5;
            if ((l5 = l4 - System.nanoTime()) > 0L) {
                do {
                    UA.park0(false, l5);
                } while ((l5 = l4 - System.nanoTime()) > 0L);
                this.handleLongOccupation();
                if (bl && (long)n++ == l3) {
                    WispEngine.WISP_ROOT_ENGINE.scheduler.checkAndGrowWorkers(Runtime.getRuntime().availableProcessors());
                    n = 0;
                }
            }
            l4 += l;
        }
    }

    private void handleLongOccupation() {
        for (WispCarrier wispCarrier : this.carriers) {
            if (wispCarrier.terminated) {
                this.carriers.remove(wispCarrier);
                continue;
            }
            if (wispCarrier.isRunning() && wispCarrier.schedTick == wispCarrier.lastSchedTick) {
                this.longOccupationEngines.add(wispCarrier);
            }
            wispCarrier.lastSchedTick = wispCarrier.schedTick;
        }
        if (!this.longOccupationEngines.isEmpty()) {
            Iterator<WispCarrier> iterator = this.longOccupationEngines.iterator();
            while (iterator.hasNext()) {
                WispCarrier wispCarrier;
                wispCarrier = iterator.next();
                WispConfiguration.HANDOFF_POLICY.handle(wispCarrier, !iterator.hasNext());
                iterator.remove();
            }
        }
        assert (this.longOccupationEngines.isEmpty());
    }

    private static native void registerNatives();

    private static native void markPreempted(Thread var0, boolean var1);

    static {
        $VALUES = new WispSysmon[]{INSTANCE};
        WispSysmon.registerNatives();
        UA = SharedSecrets.getUnsafeAccess();
        JLA = SharedSecrets.getJavaLangAccess();
    }

    static enum Policy {
        HAND_OFF{

            @Override
            void handle(WispCarrier wispCarrier, boolean bl) {
                if (JLA.isInSameNative(wispCarrier.thread)) {
                    wispCarrier.handOff();
                    INSTANCE.carriers.remove(wispCarrier);
                }
            }
        }
        ,
        PREEMPT{

            @Override
            void handle(WispCarrier wispCarrier, boolean bl) {
                WispSysmon.markPreempted(wispCarrier.thread, bl);
            }
        }
        ,
        ADAPTIVE{

            @Override
            void handle(WispCarrier wispCarrier, boolean bl) {
                if (JLA.isInSameNative(wispCarrier.thread)) {
                    wispCarrier.handOff();
                    INSTANCE.carriers.remove(wispCarrier);
                } else {
                    WispSysmon.markPreempted(wispCarrier.thread, bl);
                }
            }
        };


        abstract void handle(WispCarrier var1, boolean var2);
    }
}

