/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.util.classnames;

import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

class LineNumberHandler
extends DefaultHandler {
    final Stack<Element> elementStack = new Stack();
    final StringBuilder textBuffer = new StringBuilder();
    private Locator locator;
    private Document doc;
    static final String LINE_NUMBER_KEY_NAME = "lineNumber";

    public LineNumberHandler(Document doc) {
        this.doc = doc;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.addTextIfNeeded();
        Element el = this.doc.createElement(qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            el.setAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        el.setUserData(LINE_NUMBER_KEY_NAME, String.valueOf(this.locator.getLineNumber()), null);
        this.elementStack.push(el);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.addTextIfNeeded();
        Element closedEl = this.elementStack.pop();
        if (this.elementStack.isEmpty()) {
            this.doc.appendChild(closedEl);
        } else {
            Element parentEl = this.elementStack.peek();
            parentEl.appendChild(closedEl);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.textBuffer.append(ch, start, length);
    }

    private void addTextIfNeeded() {
        if (this.textBuffer.length() > 0) {
            Element el = this.elementStack.peek();
            Text textNode = this.doc.createTextNode(this.textBuffer.toString());
            el.appendChild(textNode);
            this.textBuffer.delete(0, this.textBuffer.length());
        }
    }
}

