/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tenant;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;

class TenantShutdownHooks {
    private IdentityHashMap<Thread, Thread> hooks = new IdentityHashMap();
    private Collection<Thread> threads = null;

    TenantShutdownHooks() {
    }

    synchronized void add(Thread thread) {
        if (this.hooks == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        if (thread.isAlive()) {
            throw new IllegalArgumentException("Hook already running");
        }
        if (this.hooks.containsKey(thread)) {
            throw new IllegalArgumentException("Hook previously registered");
        }
        this.hooks.put(thread, thread);
    }

    synchronized boolean remove(Thread thread) {
        if (this.hooks == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        if (thread == null) {
            throw new NullPointerException();
        }
        return this.hooks.remove(thread) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runHooks() {
        Iterator<Thread> iterator = this;
        synchronized (iterator) {
            this.threads = this.hooks.keySet();
            this.hooks = null;
        }
        for (Thread thread : this.threads) {
            thread.start();
        }
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

