/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.wisp.engine.StealAwareRunnable;
import com.alibaba.wisp.engine.TimeOut;
import com.alibaba.wisp.engine.WispConfiguration;
import com.alibaba.wisp.engine.WispCounter;
import com.alibaba.wisp.engine.WispEngine;
import com.alibaba.wisp.engine.WispEventPump;
import com.alibaba.wisp.engine.WispScheduler;
import com.alibaba.wisp.engine.WispTask;
import java.dyn.Coroutine;
import java.dyn.CoroutineSupport;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class WispCarrier
implements Comparable<WispCarrier> {
    private static final AtomicIntegerFieldUpdater<WispEngine> TASK_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WispEngine.class, "runningTaskCount");
    WispScheduler.Worker worker;
    final Thread thread;
    private final WispTask threadTask;
    WispEngine engine;
    WispTask current;
    private final List<WispTask> taskCache = new ArrayList<WispTask>();
    boolean isInCritical;
    WispCounter counter;
    int schedTick;
    int lastSchedTick;
    boolean terminated;
    private long switchTimestamp = 0L;
    private WispTask yieldingTask;
    private TimeOut pendingTimer;
    private static int resumeFailure = 0;

    static WispCarrier current() {
        Thread thread = WispEngine.JLA.currentThread0();
        WispTask wispTask = WispEngine.JLA.getWispTask(thread);
        if (wispTask == null) {
            WispCarrier wispCarrier = new WispCarrier(WispEngine.WISP_ROOT_ENGINE);
            if (wispCarrier.threadTask.ctx != null) {
                WispEngine.JLA.setWispTask(thread, wispCarrier.getCurrentTask());
                wispCarrier.init();
            }
            return wispCarrier;
        }
        return wispTask.carrier;
    }

    private WispCarrier(WispEngine wispEngine) {
        this.thread = WispEngine.JLA.currentThread0();
        this.engine = wispEngine;
        CoroutineSupport coroutineSupport = WispEngine.JLA.getCoroutineSupport(this.thread);
        this.current = this.threadTask = new WispTask(this, coroutineSupport == null ? null : coroutineSupport.threadCoroutine(), coroutineSupport != null, true, WispConfiguration.STACK_SIZE);
        if (coroutineSupport == null) {
            this.threadTask.setThreadWrapper(this.thread);
        } else {
            this.threadTask.reset(null, "THREAD: " + this.thread.getName(), this.thread, this.thread.getContextClassLoader());
        }
    }

    private void init() {
        WispTask.trackTask(this.threadTask);
        this.counter = WispCounter.create(this);
    }

    WispTask getCurrentTask() {
        return this.current;
    }

    long getId() {
        assert (this.thread != null);
        return this.thread.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final WispTask runTaskInternal(Runnable runnable, String string, Thread thread, ClassLoader classLoader, long l) {
        WispTask wispTask;
        if (this.engine.hasBeenShutdown.booleanValue() && !"SHUTDOWN_TASK".equals(string)) {
            throw new RejectedExecutionException("Wisp carrier has been shutdown");
        }
        assert (this.current == this.threadTask);
        boolean bl = this.isInCritical;
        this.isInCritical = true;
        try {
            this.counter.incrementCreateTaskCount();
            wispTask = this.getTaskFromCache(l);
            if (wispTask == null) {
                wispTask = new WispTask(this, null, true, false, l);
                WispTask.trackTask(wispTask);
            }
            wispTask.reset(runnable, string, thread, classLoader);
            TASK_COUNT_UPDATER.incrementAndGet(this.engine);
        }
        finally {
            this.isInCritical = bl;
        }
        wispTask.enterTs = System.nanoTime();
        this.yieldTo(wispTask, false);
        this.runWispTaskEpilog();
        return wispTask;
    }

    void taskExit() {
        this.current.countExecutionTime(this.switchTimestamp);
        this.switchTimestamp = 0L;
        this.current.setEpollArray(0L);
        this.unregisterEvent();
        boolean bl = !this.current.shutdownPending && this.returnTaskToCache(this.current);
        TASK_COUNT_UPDATER.decrementAndGet(this.engine);
        if (!bl) {
            WispTask.cleanExitedTask(this.current);
        }
        this.current.resetThreadWrapper();
        this.counter.incrementCompleteTaskCount();
        this.schedule(!bl);
    }

    private WispTask getTaskFromCache(long l) {
        if (l != (long)WispConfiguration.STACK_SIZE) {
            return null;
        }
        assert (WispCarrier.current() == this);
        if (!this.taskCache.isEmpty()) {
            return this.taskCache.remove(this.taskCache.size() - 1);
        }
        if (this.engine.hasBeenShutdown.booleanValue()) {
            return null;
        }
        WispTask wispTask = this.engine.groupTaskCache.poll();
        if (wispTask == null) {
            return null;
        }
        if (wispTask.carrier != this && this.steal(wispTask) != Coroutine.StealResult.SUCCESS) {
            this.engine.groupTaskCache.add(wispTask);
            return null;
        }
        assert (wispTask.carrier == this);
        return wispTask;
    }

    private boolean returnTaskToCache(WispTask wispTask) {
        if (wispTask.stackSize != (long)WispConfiguration.STACK_SIZE) {
            return false;
        }
        if (this.taskCache.size() > WispConfiguration.WISP_ENGINE_TASK_CACHE_SIZE && !this.engine.hasBeenShutdown.booleanValue()) {
            if (this.engine.groupTaskCache.size() > WispConfiguration.WISP_ENGINE_TASK_GLOBAL_CACHE_SIZE) {
                return false;
            }
            this.engine.groupTaskCache.add(wispTask);
        } else {
            this.taskCache.add(wispTask);
        }
        return true;
    }

    private void runWispTaskEpilog() {
        this.processPendingTimer();
        this.processYield();
    }

    void destroy() {
        WispTask.cleanExitedTasks(this.taskCache);
        WispTask.cleanExitedTask(this.threadTask);
        this.terminated = true;
    }

    final void schedule(boolean bl) {
        assert (WispCarrier.current() == this);
        WispTask wispTask = this.current;
        wispTask.countExecutionTime(this.switchTimestamp);
        assert (wispTask.resumeEntry != null && wispTask != this.threadTask) : "call `schedule()` in scheduler";
        if (wispTask.controlGroup != null) {
            wispTask.totalTs += wispTask.controlGroup.calcCpuTicks(wispTask);
        } else {
            wispTask.totalTs += System.nanoTime() - wispTask.enterTs;
            wispTask.enterTs = 0L;
        }
        wispTask.resumeEntry.setStealEnable(true);
        this.yieldTo(this.threadTask, bl);
        wispTask.carrier.checkAndDispatchShutdown();
    }

    private void checkAndDispatchShutdown() {
        assert (WispCarrier.current() == this);
        WispTask wispTask = WispCarrier.current().getCurrentTask();
        if (this.shutdownPending(wispTask) && CoroutineSupport.checkAndThrowException(wispTask.ctx)) {
            wispTask.shutdownPending = true;
            throw new ThreadDeath();
        }
    }

    boolean shutdownPending(WispTask wispTask) {
        return (this.engine.hasBeenShutdown != false || wispTask.inDestoryedGroup() && wispTask.inheritedFromNonRootContainer()) && !"SHUTDOWN_TASK".equals(wispTask.getName()) && wispTask.isAlive();
    }

    void wakeupTask(WispTask wispTask) {
        assert (!wispTask.isThreadTask());
        assert (wispTask.resumeEntry != null);
        assert (wispTask.carrier == this);
        wispTask.updateEnqueueTime();
        this.engine.scheduler.executeWithWorkerThread(wispTask.resumeEntry, this.thread);
    }

    StealAwareRunnable createResumeEntry(final WispTask wispTask) {
        assert (!wispTask.isThreadTask());
        return new StealAwareRunnable(){
            boolean stealEnable = true;

            @Override
            public void run() {
                WispCarrier wispCarrier = wispTask.carrier;
                WispCarrier wispCarrier2 = WispCarrier.current();
                if (wispCarrier != wispCarrier2) {
                    Coroutine.StealResult stealResult = wispCarrier2.steal(wispTask);
                    if (stealResult != Coroutine.StealResult.SUCCESS) {
                        if (stealResult != Coroutine.StealResult.FAIL_BY_CONTENTION) {
                            this.stealEnable = false;
                        }
                        wispCarrier.wakeupTask(wispTask);
                        return;
                    }
                    if (wispCarrier.worker.hasBeenHandoff && TASK_COUNT_UPDATER.get(wispCarrier.engine) == 0) {
                        wispCarrier.worker.signal();
                    }
                }
                wispCarrier2.countEnqueueTime(wispTask.getEnqueueTime());
                wispTask.resetEnqueueTime();
                if (wispTask.controlGroup != null) {
                    long l = wispTask.controlGroup.checkCpuLimit(wispTask, false);
                    if (l != 0L) {
                        ++wispTask.controlGroup.cpuLimitationReached;
                        wispCarrier2.resumeLater(System.nanoTime() + l, wispTask);
                        return;
                    }
                } else {
                    wispTask.enterTs = System.nanoTime();
                }
                if (wispCarrier2.yieldTo(wispTask, false)) {
                    wispCarrier2.runWispTaskEpilog();
                } else if (wispTask.isAlive()) {
                    resumeFailure++;
                    wispCarrier2.wakeupTask(wispTask);
                }
            }

            @Override
            public void setStealEnable(boolean bl) {
                this.stealEnable = bl;
            }

            @Override
            public boolean isStealEnable() {
                return this.stealEnable;
            }
        };
    }

    private Coroutine.StealResult steal(WispTask wispTask) {
        if (this.engine.hasBeenShutdown.booleanValue()) {
            return Coroutine.StealResult.FAIL_BY_STATUS;
        }
        assert (WispCarrier.current() == this);
        assert (!wispTask.isThreadTask());
        if (wispTask.carrier != this) {
            while (wispTask.stealLock != 0) {
            }
            Coroutine.StealResult stealResult = wispTask.ctx.steal(true);
            if (stealResult != Coroutine.StealResult.SUCCESS) {
                ++wispTask.stealFailureCount;
                return stealResult;
            }
            ++wispTask.stealCount;
            wispTask.setCarrier(this);
        }
        return Coroutine.StealResult.SUCCESS;
    }

    private boolean yieldTo(WispTask wispTask, boolean bl) {
        assert (wispTask != null);
        assert (WispCarrier.current() == this);
        assert (wispTask.carrier == this);
        assert (wispTask != this.current);
        ++this.schedTick;
        if (!wispTask.isAlive()) {
            this.unregisterEvent(wispTask);
            return false;
        }
        WispTask wispTask2 = this.current;
        this.current = wispTask;
        this.counter.incrementSwitchCount();
        this.switchTimestamp = WispEngine.getNanoTime();
        assert (!this.isInCritical);
        boolean bl2 = WispTask.switchTo(wispTask2, wispTask, bl);
        assert (bl2) : "coroutine switch failure";
        assert (WispCarrier.current().current == wispTask2);
        assert (!wispTask2.carrier.isInCritical);
        return bl2;
    }

    void yield() {
        if (!WispConfiguration.WISP_HIGH_PRECISION_TIMER && this.worker != null) {
            this.worker.processTimer();
        }
        if (WispEngine.runningAsCoroutine(this.current.getThreadWrapper())) {
            boolean bl = this.current.controlGroup != null;
            boolean bl2 = false;
            int n = this.getTaskQueueLength();
            if (n == 0 && bl) {
                this.current.controlGroup.calcCpuTicks(this.current);
                boolean bl3 = bl2 = this.current.controlGroup.checkCpuLimit(this.current, true) != 0L;
            }
            if (n > 0 || bl && bl2) {
                assert (this.yieldingTask == null);
                this.yieldingTask = this.current;
                this.schedule(false);
            }
            WispCarrier.current().checkAndDispatchShutdown();
        } else {
            WispEngine.JLA.yield0();
        }
    }

    private void processYield() {
        assert (this.current.isThreadTask());
        if (this.yieldingTask != null) {
            this.wakeupTask(this.yieldingTask);
            this.yieldingTask = null;
        }
    }

    void registerEvent(SelectableChannel selectableChannel, int n) throws IOException {
        this.registerEvent(this.current, selectableChannel, n);
    }

    private void registerEvent(WispTask wispTask, SelectableChannel selectableChannel, int n) throws IOException {
        if (selectableChannel != null && selectableChannel.isOpen() && n != 0) {
            WispEventPump.Pool.INSTANCE.registerEvent(wispTask, selectableChannel, n);
        }
    }

    void unregisterEvent() {
        this.unregisterEvent(this.current);
    }

    private void unregisterEvent(WispTask wispTask) {
        if (wispTask.ch != null) {
            wispTask.resetRegisterEventTime();
            wispTask.ch = null;
        }
    }

    void addTimer(long l, TimeOut.Action action) {
        WispTask wispTask = this.current;
        this.addTimerInternal(l, wispTask, action, true);
    }

    private void resumeLater(long l, WispTask wispTask) {
        assert (wispTask != null);
        this.addTimerInternal(l, wispTask, TimeOut.Action.RESUME, false);
    }

    private void addTimerInternal(long l, WispTask wispTask, TimeOut.Action action, boolean bl) {
        TimeOut timeOut = new TimeOut(wispTask, l, action);
        if (bl) {
            wispTask.timeOut = timeOut;
        }
        if (WispConfiguration.WISP_HIGH_PRECISION_TIMER) {
            if (wispTask.isThreadTask()) {
                this.scheduleInTimer(timeOut);
            } else {
                this.pendingTimer = timeOut;
            }
        } else {
            this.engine.scheduler.addTimer(timeOut, this.thread);
        }
    }

    void cancelTimer() {
        if (this.current.timeOut != null) {
            this.current.timeOut.canceled = true;
            if (!WispConfiguration.WISP_HIGH_PRECISION_TIMER) {
                this.engine.scheduler.cancelTimer(this.current.timeOut, this.thread);
            }
            this.current.timeOut = null;
        }
        this.pendingTimer = null;
    }

    private void processPendingTimer() {
        assert (this.current.isThreadTask());
        if (WispConfiguration.WISP_HIGH_PRECISION_TIMER && this.pendingTimer != null) {
            this.scheduleInTimer(this.pendingTimer);
            this.pendingTimer = null;
        }
    }

    private void scheduleInTimer(final TimeOut timeOut) {
        boolean bl = this.isInCritical;
        long l = timeOut.deadlineNano - System.nanoTime();
        this.isInCritical = true;
        if (l > 0L) {
            WispEngine.timer.schedule(new Runnable(){

                @Override
                public void run() {
                    if (!timeOut.canceled) {
                        timeOut.doAction();
                    }
                }
            }, l, TimeUnit.NANOSECONDS);
        } else if (!timeOut.canceled) {
            timeOut.task.jdkUnpark();
        }
        this.isInCritical = bl;
    }

    boolean isRunning() {
        return this.current != this.threadTask;
    }

    int getTaskQueueLength() {
        if (this.worker == null) {
            return 0;
        }
        int n = this.worker.queueLength;
        return Math.max(n, 0);
    }

    int getRunningTaskCount() {
        return this.engine.runningTaskCount;
    }

    void handOff() {
        this.engine.scheduler.handOffWorkerThread(this.thread);
    }

    WispCounter getCounter() {
        return this.counter;
    }

    void countEnqueueTime(long l) {
        if (l != 0L) {
            this.counter.incrementTotalEnqueueTime(System.nanoTime() - l);
        }
    }

    public String toString() {
        return "WispCarrier on " + this.thread.getName();
    }

    @Override
    public int compareTo(WispCarrier wispCarrier) {
        return Long.compare(this.getId(), wispCarrier.getId());
    }
}

