/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.rcm.Constraint;
import com.alibaba.rcm.ResourceContainer;
import com.alibaba.rcm.ResourceType;
import com.alibaba.rcm.internal.AbstractResourceContainer;
import com.alibaba.rcm.internal.ResourceContainerGlobals;
import com.alibaba.wisp.engine.WispCarrier;
import com.alibaba.wisp.engine.WispConfiguration;
import com.alibaba.wisp.engine.WispEngine;
import com.alibaba.wisp.engine.WispTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class WispControlGroup
extends AbstractExecutorService {
    private static final int SCHEDULE_TIMES = 5;
    private static final int MAX_PERIOD = 100000;
    private static final int MIN_PERIOD = 10000;
    private static final int ESTIMATED_PERIOD = Math.max(10000, Math.min(100000, WispConfiguration.SYSMON_TICK_US * 5));
    private static final AtomicReferenceFieldUpdater<WispControlGroup, Boolean> SHUTDOWN_UPDATER = AtomicReferenceFieldUpdater.newUpdater(WispControlGroup.class, Boolean.class, "destroyed");
    private CpuLimit cpuLimit;
    private final AtomicLong currentPeriodStart;
    private final AtomicLong remainQuota;
    volatile Boolean destroyed = false;
    private long totalConsume = 0L;
    long cpuLimitationReached = 0L;
    CountDownLatch destroyLatch = new CountDownLatch(1);

    private static int defaultCfsPeriod() {
        int n = WispConfiguration.WISP_CONTROL_GROUP_CFS_PERIOD;
        return n == 0 ? ESTIMATED_PERIOD : n;
    }

    static WispControlGroup newInstance(int n, int n2) {
        return new WispControlGroup(n, n2);
    }

    static WispControlGroup newInstance(int n) {
        int n2 = WispControlGroup.defaultCfsPeriod();
        int n3 = (int)((double)n2 * (double)n / 100.0);
        return new WispControlGroup(n3, n2);
    }

    static WispControlGroup newInstance() {
        int n = WispControlGroup.defaultCfsPeriod();
        int n2 = n * Runtime.getRuntime().availableProcessors();
        return new WispControlGroup(n, n2);
    }

    private WispControlGroup(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Invalid parameter: cfsQuotaUs or cfsPeriodUs should be positive number");
        }
        this.cpuLimit = new CpuLimit(n, n2);
        this.currentPeriodStart = new AtomicLong();
        this.remainQuota = new AtomicLong();
    }

    long checkCpuLimit(WispTask wispTask, boolean bl) {
        long l;
        long l2;
        long l3;
        assert (wispTask.controlGroup == this);
        assert (wispTask.enterTs == 0L);
        CpuLimit cpuLimit = this.cpuLimit;
        long l4 = System.nanoTime();
        if (l4 > (l3 = this.currentPeriodStart.get()) + cpuLimit.cfsPeriod && this.currentPeriodStart.compareAndSet(l3, l4)) {
            l2 = (long)((double)(l4 - l3) / (double)cpuLimit.cfsPeriod * (double)cpuLimit.cfsQuota);
            l3 = l4;
            while (!this.remainQuota.compareAndSet(l = this.remainQuota.get(), Math.min(l + l2, cpuLimit.cfsQuota))) {
            }
        }
        if ((l2 = this.remainQuota.get()) >= 0L) {
            wispTask.enterTs = System.nanoTime();
            wispTask.ttr = 0L;
            return 0L;
        }
        if (bl) {
            wispTask.enterTs = System.nanoTime();
        }
        l = (long)((double)(-l2) / (double)cpuLimit.cfsQuota * (double)cpuLimit.cfsPeriod);
        l = Math.max(l, l3 + cpuLimit.cfsPeriod - l4);
        wispTask.ttr = l / 1000L;
        assert (l > 0L);
        return l;
    }

    long calcCpuTicks(WispTask wispTask) {
        assert (wispTask.controlGroup == this);
        assert (wispTask.enterTs != 0L);
        long l = System.nanoTime() - wispTask.enterTs;
        this.remainQuota.addAndGet(-l);
        wispTask.enterTs = 0L;
        this.totalConsume += l;
        return l;
    }

    private void attach() {
        WispTask wispTask = WispCarrier.current().current;
        assert (wispTask.controlGroup == null);
        if (wispTask.enterTs != 0L) {
            wispTask.totalTs += System.nanoTime() - wispTask.enterTs;
            wispTask.enterTs = 0L;
        }
        wispTask.controlGroup = this;
        long l = this.checkCpuLimit(wispTask, true);
        if (l != 0L) {
            try {
                WispTask.jdkPark(l);
            }
            catch (ThreadDeath threadDeath) {
                assert (wispTask.enterTs != 0L);
                this.detach();
                throw threadDeath;
            }
        }
        assert (wispTask.enterTs != 0L);
    }

    private void detach() {
        WispTask wispTask = WispCarrier.current().current;
        assert (wispTask.controlGroup != null);
        wispTask.controlGroup.calcCpuTicks(wispTask);
        wispTask.controlGroup = null;
    }

    Runnable wrap(Runnable runnable) {
        return () -> {
            this.attach();
            try {
                WispTask.runOutsideWisp(runnable);
            }
            finally {
                this.detach();
            }
        };
    }

    @Override
    public void execute(Runnable runnable) {
        WispEngine.dispatch(this.wrap(runnable));
    }

    @Override
    public void shutdown() {
        if (SHUTDOWN_UPDATER.compareAndSet(this, false, true)) {
            WispEngine.WISP_ROOT_ENGINE.shutdown(this);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean isShutdown() {
        return this.destroyed;
    }

    @Override
    public boolean isTerminated() {
        return this.destroyLatch.getCount() == 0L;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.destroyLatch.await(l, timeUnit);
    }

    public String toString() {
        CpuLimit cpuLimit = this.cpuLimit;
        return "WispControlGroup{" + cpuLimit.cfsQuota / 1000L + "/" + cpuLimit.cfsPeriod / 1000L + '}';
    }

    ResourceContainer createResourceContainer() {
        return new AbstractResourceContainer(){
            private Constraint constraint;
            private Properties props;
            {
                if (ResourceContainerGlobals.propertyIsolationEnabled()) {
                    this.setProperties(null);
                }
            }

            @Override
            public ResourceContainer.State getState() {
                if (WispControlGroup.this.isTerminated()) {
                    return ResourceContainer.State.DEAD;
                }
                if (WispControlGroup.this.isShutdown()) {
                    return ResourceContainer.State.STOPPING;
                }
                return ResourceContainer.State.RUNNING;
            }

            @Override
            public void updateConstraint(Constraint constraint) {
                if (constraint.getResourceType() != ResourceType.CPU_PERCENT) {
                    throw new IllegalArgumentException("Resource type is not CPU_PERCENT");
                }
                this.constraint = constraint;
                long[] lArray = constraint.getValues();
                long l = lArray[0];
                int n = WispControlGroup.defaultCfsPeriod();
                int n2 = (int)((double)n * (double)l / 100.0);
                WispControlGroup.this.cpuLimit = new CpuLimit(n2, n);
            }

            @Override
            public Iterable<Constraint> getConstraints() {
                assert (this.constraint != null);
                return Collections.singletonList(this.constraint);
            }

            @Override
            public Properties getProperties() {
                return this.props;
            }

            @Override
            public void setProperties(Properties properties) {
                if (properties == null) {
                    ResourceContainer.root().run(() -> {
                        this.props = new Properties();
                        this.props.putAll(System.getProperties());
                    });
                } else {
                    this.props = properties;
                }
            }

            @Override
            public void destroy() {
                WispControlGroup.this.shutdown();
                while (!WispControlGroup.this.isTerminated()) {
                    try {
                        WispControlGroup.this.awaitTermination(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InternalError(interruptedException);
                    }
                }
            }

            @Override
            public Long getConsumedAmount(ResourceType resourceType) {
                if (resourceType != ResourceType.CPU_PERCENT) {
                    return 0L;
                }
                return WispControlGroup.this.totalConsume;
            }

            @Override
            public Long getResourceLimitReachedCount(ResourceType resourceType) {
                if (resourceType != ResourceType.CPU_PERCENT) {
                    return 0L;
                }
                return WispControlGroup.this.cpuLimitationReached;
            }

            @Override
            public List<Long> getActiveContainerThreadIds() {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                for (WispTask wispTask : WispTask.id2Task.values()) {
                    if (!wispTask.isAlive() || wispTask.getThreadWrapper() == null || wispTask.controlGroup != WispControlGroup.this) continue;
                    arrayList.add(wispTask.getThreadWrapper().getId());
                }
                return arrayList;
            }

            @Override
            protected void attach() {
                super.attach();
                WispControlGroup.this.attach();
            }

            @Override
            protected void detach() {
                WispControlGroup.this.detach();
                super.detach();
            }
        };
    }

    private static class CpuLimit {
        long cfsPeriod;
        long cfsQuota;

        CpuLimit(int n, int n2) {
            this.cfsQuota = TimeUnit.MICROSECONDS.toNanos(n);
            this.cfsPeriod = TimeUnit.MICROSECONDS.toNanos(n2);
        }
    }
}

