/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import com.alibaba.tenant.TenantContainer;
import com.alibaba.tenant.TenantData;
import com.alibaba.tenant.TenantGlobals;
import com.alibaba.tenant.TenantState;
import java.lang.ref.FinalReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.VM;

final class Finalizer
extends FinalReference<Object> {
    private static ReferenceQueue<Object> queue = new ReferenceQueue();
    private static Finalizer unfinalized = null;
    private static final Object lock = new Object();
    private static final String ID_UNFINALIZED = "unfinalized";
    private Finalizer next = null;
    private Finalizer prev = null;

    private static ReferenceQueue<Object> initTenantReferenceQueue() {
        if (!TenantGlobals.isDataIsolationEnabled() || TenantContainer.current() == null) {
            throw new UnsupportedOperationException();
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new FinalizerThread(threadGroup);
        SharedSecrets.getTenantAccess().registerServiceThread(TenantContainer.current(), (Thread)object);
        ((Thread)object).setName("TenantFinalizer-" + TenantContainer.current().getTenantId());
        ((Thread)object).setPriority(8);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
        return new ReferenceQueue<Object>();
    }

    private boolean hasBeenFinalized() {
        return this.next == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add() {
        Object object = lock;
        synchronized (object) {
            if (VM.isBooted() && TenantGlobals.isDataIsolationEnabled() && TenantContainer.current() != null) {
                TenantData tenantData = TenantContainer.current().getTenantData();
                Finalizer finalizer = (Finalizer)tenantData.getFieldValue(Finalizer.class, ID_UNFINALIZED);
                if (finalizer != null) {
                    this.next = finalizer;
                    finalizer.prev = this;
                }
                tenantData.setFieldValue(Finalizer.class, ID_UNFINALIZED, this);
            } else {
                if (unfinalized != null) {
                    this.next = unfinalized;
                    Finalizer.unfinalized.prev = this;
                }
                unfinalized = this;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = lock;
        synchronized (object) {
            if (TenantGlobals.isDataIsolationEnabled() && TenantContainer.current() != null) {
                TenantData tenantData = TenantContainer.current().getTenantData();
                if (tenantData.getFieldValue(Finalizer.class, ID_UNFINALIZED) == this) {
                    if (this.next != null) {
                        tenantData.setFieldValue(Finalizer.class, ID_UNFINALIZED, this.next);
                    } else {
                        tenantData.setFieldValue(Finalizer.class, ID_UNFINALIZED, this.prev);
                    }
                }
            } else if (unfinalized == this) {
                unfinalized = this.next != null ? this.next : this.prev;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.next = this;
            this.prev = this;
        }
    }

    private Finalizer(Object object) {
        super(object, Finalizer.getQueue());
        this.add();
    }

    static ReferenceQueue<Object> getQueue() {
        if (VM.isBooted() && TenantGlobals.isDataIsolationEnabled() && TenantContainer.current() != null) {
            return TenantContainer.current().getFieldValue(Finalizer.class, "queue", Finalizer::initTenantReferenceQueue);
        }
        return queue;
    }

    static void register(Object object) {
        new Finalizer(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizer(JavaLangAccess javaLangAccess) {
        Finalizer finalizer = this;
        synchronized (finalizer) {
            if (this.hasBeenFinalized()) {
                return;
            }
            this.remove();
        }
        try {
            finalizer = this.get();
            if (finalizer != null && !(finalizer instanceof Enum)) {
                javaLangAccess.invokeFinalize(finalizer);
                finalizer = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.clear();
    }

    private static void forkSecondaryFinalizer(final Runnable runnable) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                Object object = threadGroup;
                while (object != null) {
                    threadGroup = object;
                    object = threadGroup.getParent();
                }
                object = new Thread(threadGroup, runnable, "Secondary finalizer");
                if (TenantGlobals.isDataIsolationEnabled() && TenantContainer.current() != null) {
                    SharedSecrets.getTenantAccess().registerServiceThread(TenantContainer.current(), (Thread)object);
                }
                ((Thread)object).start();
                try {
                    ((Thread)object).join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }
        });
    }

    static void runFinalization() {
        if (!VM.isBooted()) {
            return;
        }
        Finalizer.forkSecondaryFinalizer(new Runnable(){
            private volatile boolean running;

            @Override
            public void run() {
                Finalizer finalizer;
                if (this.running) {
                    return;
                }
                JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
                this.running = true;
                ReferenceQueue<Object> referenceQueue = Finalizer.getQueue();
                while ((finalizer = (Finalizer)referenceQueue.poll()) != null) {
                    finalizer.runFinalizer(javaLangAccess);
                }
            }
        });
    }

    static {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new FinalizerThread(threadGroup);
        ((Thread)object).setPriority(8);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    private static class FinalizerThread
    extends Thread {
        private volatile boolean running;

        FinalizerThread(ThreadGroup threadGroup) {
            super(threadGroup, "Finalizer");
        }

        @Override
        public void run() {
            if (this.running) {
                return;
            }
            while (!VM.isBooted()) {
                try {
                    VM.awaitBooted();
                }
                catch (InterruptedException interruptedException) {}
            }
            JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
            this.running = true;
            ReferenceQueue<Object> referenceQueue = Finalizer.getQueue();
            while (referenceQueue != null) {
                try {
                    Finalizer finalizer = (Finalizer)referenceQueue.remove();
                    finalizer.runFinalizer(javaLangAccess);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!TenantGlobals.isDataIsolationEnabled() || TenantContainer.current() == null || TenantContainer.current().getState() != TenantState.DEAD) continue;
                break;
            }
        }
    }
}

