/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import com.alibaba.tenant.TenantContainer;
import com.alibaba.tenant.TenantGlobals;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverAction;
import java.sql.DriverInfo;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public class DriverManager {
    private static final CopyOnWriteArrayList<DriverInfo> registeredDrivers = new CopyOnWriteArrayList();
    private static volatile int loginTimeout = 0;
    private static volatile PrintWriter logWriter = null;
    private static volatile PrintStream logStream = null;
    private static final Object logSync = new Object();
    static final SQLPermission SET_LOG_PERMISSION;
    static final SQLPermission DEREGISTER_DRIVER_PERMISSION;

    private DriverManager() {
    }

    private static CopyOnWriteArrayList<DriverInfo> getRegisteredDrivers() {
        if (TenantGlobals.isDataIsolationEnabled() && TenantContainer.current() != null) {
            return TenantContainer.current().getFieldValue(DriverManager.class, "registeredDrivers", () -> new CopyOnWriteArrayList());
        }
        return registeredDrivers;
    }

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static void setLogWriter(PrintWriter printWriter) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = null;
        logWriter = printWriter;
    }

    @CallerSensitive
    public static Connection getConnection(String string, Properties properties) throws SQLException {
        return DriverManager.getConnection(string, properties, Reflection.getCallerClass());
    }

    @CallerSensitive
    public static Connection getConnection(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        if (string2 != null) {
            properties.put("user", string2);
        }
        if (string3 != null) {
            properties.put("password", string3);
        }
        return DriverManager.getConnection(string, properties, Reflection.getCallerClass());
    }

    @CallerSensitive
    public static Connection getConnection(String string) throws SQLException {
        Properties properties = new Properties();
        return DriverManager.getConnection(string, properties, Reflection.getCallerClass());
    }

    @CallerSensitive
    public static Driver getDriver(String string) throws SQLException {
        DriverManager.println("DriverManager.getDriver(\"" + string + "\")");
        Class<?> clazz = Reflection.getCallerClass();
        for (DriverInfo driverInfo : DriverManager.getRegisteredDrivers()) {
            if (DriverManager.isDriverAllowed(driverInfo.driver, clazz)) {
                try {
                    if (!driverInfo.driver.acceptsURL(string)) continue;
                    DriverManager.println("getDriver returning " + driverInfo.driver.getClass().getName());
                    return driverInfo.driver;
                }
                catch (SQLException sQLException) {
                    continue;
                }
            }
            DriverManager.println("    skipping: " + driverInfo.driver.getClass().getName());
        }
        DriverManager.println("getDriver: no suitable driver");
        throw new SQLException("No suitable driver", "08001");
    }

    public static synchronized void registerDriver(Driver driver) throws SQLException {
        DriverManager.registerDriver(driver, null);
    }

    public static synchronized void registerDriver(Driver driver, DriverAction driverAction) throws SQLException {
        if (driver == null) {
            throw new NullPointerException();
        }
        DriverManager.getRegisteredDrivers().addIfAbsent(new DriverInfo(driver, driverAction));
        DriverManager.println("registerDriver: " + driver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CallerSensitive
    public static synchronized void deregisterDriver(Driver driver) throws SQLException {
        if (driver == null) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(DEREGISTER_DRIVER_PERMISSION);
        }
        DriverManager.println("DriverManager.deregisterDriver: " + driver);
        DriverInfo driverInfo = new DriverInfo(driver, null);
        CopyOnWriteArrayList<DriverInfo> copyOnWriteArrayList = DriverManager.getRegisteredDrivers();
        if (copyOnWriteArrayList.contains(driverInfo)) {
            if (!DriverManager.isDriverAllowed(driver, Reflection.getCallerClass())) throw new SecurityException();
            DriverInfo driverInfo2 = copyOnWriteArrayList.get(copyOnWriteArrayList.indexOf(driverInfo));
            if (driverInfo2.action() != null) {
                driverInfo2.action().deregister();
            }
            copyOnWriteArrayList.remove(driverInfo);
            return;
        } else {
            DriverManager.println("    couldn't find driver to unload");
        }
    }

    @CallerSensitive
    public static Enumeration<Driver> getDrivers() {
        Vector<Driver> vector = new Vector<Driver>();
        Class<?> clazz = Reflection.getCallerClass();
        for (DriverInfo driverInfo : DriverManager.getRegisteredDrivers()) {
            if (DriverManager.isDriverAllowed(driverInfo.driver, clazz)) {
                vector.addElement(driverInfo.driver);
                continue;
            }
            DriverManager.println("    skipping: " + driverInfo.getClass().getName());
        }
        return vector.elements();
    }

    public static void setLoginTimeout(int n) {
        loginTimeout = n;
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    @Deprecated
    public static void setLogStream(PrintStream printStream) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = printStream;
        logWriter = printStream != null ? new PrintWriter(printStream) : null;
    }

    @Deprecated
    public static PrintStream getLogStream() {
        return logStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String string) {
        Object object = logSync;
        synchronized (object) {
            if (logWriter != null) {
                logWriter.println(string);
                logWriter.flush();
            }
        }
    }

    private static boolean isDriverAllowed(Driver driver, Class<?> clazz) {
        ClassLoader classLoader = clazz != null ? clazz.getClassLoader() : null;
        return DriverManager.isDriverAllowed(driver, classLoader);
    }

    private static boolean isDriverAllowed(Driver driver, ClassLoader classLoader) {
        boolean bl = false;
        if (driver != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(driver.getClass().getName(), true, classLoader);
            }
            catch (Exception exception) {
                bl = false;
            }
            bl = clazz == driver.getClass();
        }
        return bl;
    }

    private static void loadInitialDrivers() {
        String string;
        try {
            string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("jdbc.drivers");
                }
            });
        }
        catch (Exception exception) {
            string = null;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ServiceLoader<Driver> serviceLoader = ServiceLoader.load(Driver.class);
                Iterator<Driver> iterator = serviceLoader.iterator();
                try {
                    while (iterator.hasNext()) {
                        iterator.next();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        DriverManager.println("DriverManager.initialize: jdbc.drivers = " + string);
        if (string == null || string.equals("")) {
            return;
        }
        String[] stringArray = string.split(":");
        DriverManager.println("number of Drivers:" + stringArray.length);
        for (String string2 : stringArray) {
            try {
                DriverManager.println("DriverManager.Initialize: loading " + string2);
                Class.forName(string2, true, ClassLoader.getSystemClassLoader());
            }
            catch (Exception exception) {
                DriverManager.println("DriverManager.Initialize: load failed: " + exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection getConnection(String string, Properties properties, Class<?> clazz) throws SQLException {
        ClassLoader classLoader = clazz != null ? clazz.getClassLoader() : null;
        Object object = DriverManager.class;
        synchronized (DriverManager.class) {
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (string == null) {
                throw new SQLException("The url cannot be null", "08001");
            }
            DriverManager.println("DriverManager.getConnection(\"" + string + "\")");
            object = null;
            for (DriverInfo driverInfo : DriverManager.getRegisteredDrivers()) {
                if (DriverManager.isDriverAllowed(driverInfo.driver, classLoader)) {
                    try {
                        DriverManager.println("    trying " + driverInfo.driver.getClass().getName());
                        Connection connection = driverInfo.driver.connect(string, properties);
                        if (connection == null) continue;
                        DriverManager.println("getConnection returning " + driverInfo.driver.getClass().getName());
                        return connection;
                    }
                    catch (SQLException sQLException) {
                        if (object != null) continue;
                        object = sQLException;
                        continue;
                    }
                }
                DriverManager.println("    skipping: " + driverInfo.getClass().getName());
            }
            if (object != null) {
                DriverManager.println("getConnection failed: " + object);
                throw object;
            }
            DriverManager.println("getConnection: no suitable driver found for " + string);
            throw new SQLException("No suitable driver found for " + string, "08001");
        }
    }

    static {
        DriverManager.loadInitialDrivers();
        DriverManager.println("JDBC DriverManager initialized");
        SET_LOG_PERMISSION = new SQLPermission("setLog");
        DEREGISTER_DRIVER_PERMISSION = new SQLPermission("deregisterDriver");
    }
}

