/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import sun.misc.SharedSecrets;
import sun.misc.WispEngineAccess;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.Net;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.WispSocketLockSupport;

public class WispSocketImpl {
    private static WispEngineAccess WEA = SharedSecrets.getWispEngineAccess();
    WispSocketLockSupport wispSocketLockSupport = new WispSocketLockSupport();
    private SocketChannelImpl sc = null;
    private Socket so;
    protected int timeout = 0;
    private InputStream socketInputStream = null;

    public WispSocketImpl(Socket socket) {
        this.so = socket;
    }

    public WispSocketImpl(SocketChannel socketChannel, Socket socket) {
        this.so = socket;
        this.sc = (SocketChannelImpl)socketChannel;
    }

    public SocketChannel getChannel() {
        return this.sc;
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        SocketChannelImpl socketChannelImpl = this.getChannelImpl();
        try {
            this.wispSocketLockSupport.beginWrite();
            if (((SocketChannel)socketChannelImpl).connect(socketAddress)) {
                return;
            }
            if (n > 0) {
                WEA.addTimer(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(n));
            }
            do {
                WEA.registerEvent(socketChannelImpl, 8);
                WEA.park(-1L);
                if (n <= 0 || !WEA.isTimeout()) continue;
                throw new SocketTimeoutException("time out");
            } while (!((SocketChannel)socketChannelImpl).finishConnect());
        }
        catch (Exception exception) {
            try {
                Net.translateException(exception, true);
            }
            catch (IOException iOException) {
                this.sc.close();
                throw iOException;
            }
        }
        finally {
            this.wispSocketLockSupport.endWrite();
            if (n > 0) {
                WEA.cancelTimer();
            }
            if (socketChannelImpl.isBlocking()) {
                socketChannelImpl.configureBlocking(false);
            }
            WEA.unregisterEvent();
        }
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        try {
            this.getChannelImpl().bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public InetAddress getInetAddress() {
        SocketAddress socketAddress;
        SocketAddress socketAddress2 = socketAddress = this.sc == null ? null : this.sc.remoteAddress();
        if (socketAddress == null) {
            return null;
        }
        return ((InetSocketAddress)socketAddress).getAddress();
    }

    public InetAddress getLocalAddress() {
        InetSocketAddress inetSocketAddress;
        SocketChannelImpl socketChannelImpl = null;
        try {
            socketChannelImpl = this.getChannelImpl();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (socketChannelImpl != null && socketChannelImpl.isOpen() && (inetSocketAddress = socketChannelImpl.localAddress()) != null) {
            return Net.getRevealedLocalAddress(inetSocketAddress).getAddress();
        }
        return new InetSocketAddress(0).getAddress();
    }

    public int getPort() {
        SocketAddress socketAddress;
        SocketAddress socketAddress2 = socketAddress = this.sc == null ? null : this.sc.remoteAddress();
        if (socketAddress == null) {
            return 0;
        }
        return ((InetSocketAddress)socketAddress).getPort();
    }

    public int getLocalPort() {
        InetSocketAddress inetSocketAddress;
        SocketChannelImpl socketChannelImpl = null;
        try {
            socketChannelImpl = this.getChannelImpl();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        InetSocketAddress inetSocketAddress2 = inetSocketAddress = socketChannelImpl == null ? null : socketChannelImpl.localAddress();
        if (inetSocketAddress == null) {
            return -1;
        }
        return inetSocketAddress.getPort();
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            try {
                this.socketInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return new WispSocketInputStream(WispSocketImpl.this.getChannelImpl());
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
        return this.socketInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    return new WispSocketOutputStream(WispSocketImpl.this.getChannelImpl());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void setBooleanOption(SocketOption<Boolean> socketOption, boolean bl) throws SocketException {
        try {
            this.getChannelImpl().setOption((SocketOption)socketOption, (Object)bl);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private void setIntOption(SocketOption<Integer> socketOption, int n) throws SocketException {
        try {
            this.getChannelImpl().setOption((SocketOption)socketOption, (Object)n);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private boolean getBooleanOption(SocketOption<Boolean> socketOption) throws SocketException {
        try {
            return this.getChannelImpl().getOption(socketOption);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return false;
        }
    }

    private int getIntOption(SocketOption<Integer> socketOption) throws SocketException {
        try {
            return this.getChannelImpl().getOption(socketOption);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return -1;
        }
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.TCP_NODELAY, bl);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.TCP_NODELAY);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (!bl) {
            n = -1;
        }
        this.setIntOption(StandardSocketOptions.SO_LINGER, n);
    }

    public int getSoLinger() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_LINGER);
    }

    public void sendUrgentData(int n) throws IOException {
        int n2 = this.getChannelImpl().sendOutOfBandData((byte)n);
        if (n2 == 0) {
            throw new IOException("Socket buffer full");
        }
    }

    public void setOOBInline(boolean bl) throws SocketException {
        this.setBooleanOption(ExtendedSocketOption.SO_OOBINLINE, bl);
    }

    public boolean getOOBInline() throws SocketException {
        return this.getBooleanOption(ExtendedSocketOption.SO_OOBINLINE);
    }

    public void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = n;
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    public void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid send size");
        }
        this.setIntOption(StandardSocketOptions.SO_SNDBUF, n);
    }

    public int getSendBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_SNDBUF);
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid receive size");
        }
        this.setIntOption(StandardSocketOptions.SO_RCVBUF, n);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_RCVBUF);
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_KEEPALIVE, bl);
    }

    public boolean getKeepAlive() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_KEEPALIVE);
    }

    public void setTrafficClass(int n) throws SocketException {
        this.setIntOption(StandardSocketOptions.IP_TOS, n);
    }

    public int getTrafficClass() throws SocketException {
        return this.getIntOption(StandardSocketOptions.IP_TOS);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_REUSEADDR, bl);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_REUSEADDR);
    }

    public void close() throws IOException {
        if (this.sc != null) {
            this.sc.close();
            this.wispSocketLockSupport.unparkBlockedWispTask();
        }
    }

    public void shutdownInput() throws IOException {
        try {
            this.getChannelImpl().shutdownInput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public void shutdownOutput() throws IOException {
        try {
            this.getChannelImpl().shutdownOutput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public String toString() {
        if (this.isConnected()) {
            return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
        }
        return "Socket[unconnected]";
    }

    public boolean isConnected() {
        return this.sc != null && this.sc.isConnected();
    }

    public boolean isBound() {
        return this.sc != null && this.sc.localAddress() != null;
    }

    public boolean isClosed() {
        return this.sc != null && !this.sc.isOpen();
    }

    public boolean isInputShutdown() {
        return this.sc != null && !this.sc.isInputOpen();
    }

    public boolean isOutputShutdown() {
        return this.sc != null && !this.sc.isOutputOpen();
    }

    private SocketChannelImpl getChannelImpl() throws SocketException {
        if (this.sc == null) {
            try {
                this.sc = (SocketChannelImpl)SocketChannel.open();
                this.sc.configureBlocking(false);
            }
            catch (IOException iOException) {
                throw new SocketException(iOException.getMessage());
            }
        }
        return this.sc;
    }

    private class WispSocketOutputStream
    extends OutputStream {
        protected final SocketChannel ch;
        private ByteBuffer bb = null;
        private byte[] bs = null;
        private byte[] b1 = null;

        WispSocketOutputStream(SocketChannel socketChannel) {
            this.ch = socketChannel;
        }

        @Override
        public void write(int n) throws IOException {
            if (this.b1 == null) {
                this.b1 = new byte[1];
            }
            this.b1[0] = (byte)n;
            this.write(this.b1);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 <= 0 || n < 0 || n + n2 > byArray.length) {
                if (n2 == 0) {
                    return;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            ByteBuffer byteBuffer = this.bs == byArray ? this.bb : ByteBuffer.wrap(byArray);
            byteBuffer.limit(Math.min(n + n2, byteBuffer.capacity()));
            byteBuffer.position(n);
            this.bb = byteBuffer;
            this.bs = byArray;
            this.write(byteBuffer);
        }

        private void write(ByteBuffer byteBuffer) throws IOException {
            try {
                WispSocketImpl.this.wispSocketLockSupport.beginWrite();
                this.write0(byteBuffer);
            }
            finally {
                WispSocketImpl.this.wispSocketLockSupport.endWrite();
            }
        }

        private void write0(ByteBuffer byteBuffer) throws IOException {
            try {
                int n = byteBuffer.remaining();
                if (this.ch.write(byteBuffer) == n) {
                    return;
                }
                if (WispSocketImpl.this.so.getSoTimeout() > 0) {
                    WEA.addTimer(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(WispSocketImpl.this.so.getSoTimeout()));
                }
                do {
                    WEA.registerEvent(this.ch, 4);
                    WEA.park(-1L);
                    if (WispSocketImpl.this.so.getSoTimeout() > 0 && WEA.isTimeout()) {
                        throw new SocketTimeoutException("time out");
                    }
                    this.ch.write(byteBuffer);
                } while (byteBuffer.remaining() > 0);
            }
            finally {
                if (WispSocketImpl.this.so.getSoTimeout() > 0) {
                    WEA.cancelTimer();
                }
                WEA.unregisterEvent();
            }
        }

        @Override
        public void close() throws IOException {
            WispSocketImpl.this.close();
        }
    }

    private class WispSocketInputStream
    extends InputStream {
        protected final SocketChannel ch;
        private boolean eof = false;
        private ByteBuffer bb = null;
        private byte[] bs = null;
        private byte[] b1 = null;
        private ByteBuffer readAhead = null;

        WispSocketInputStream(SocketChannel socketChannel) {
            this.ch = socketChannel;
        }

        @Override
        public int read() throws IOException {
            int n;
            if (this.b1 == null) {
                this.b1 = new byte[1];
            }
            if ((n = this.read(this.b1)) == 1) {
                return this.b1[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 <= 0 || n < 0 || n + n2 > byArray.length) {
                if (n2 == 0) {
                    return 0;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            ByteBuffer byteBuffer = this.bs == byArray ? this.bb : ByteBuffer.wrap(byArray);
            byteBuffer.limit(Math.min(n + n2, byteBuffer.capacity()));
            byteBuffer.position(n);
            this.bb = byteBuffer;
            this.bs = byArray;
            return this.read(byteBuffer);
        }

        private int read(ByteBuffer byteBuffer) throws IOException {
            try {
                WispSocketImpl.this.wispSocketLockSupport.beginRead();
                int n = this.read0(byteBuffer);
                return n;
            }
            finally {
                WispSocketImpl.this.wispSocketLockSupport.endRead();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int read0(ByteBuffer byteBuffer) throws IOException {
            int n;
            if (this.eof) {
                return -1;
            }
            try {
                if (this.readAhead != null && this.readAhead.hasRemaining()) {
                    int n2;
                    int n3;
                    if (byteBuffer.remaining() >= this.readAhead.remaining()) {
                        n3 = this.readAhead.remaining();
                        byteBuffer.put(this.readAhead);
                    } else {
                        n3 = byteBuffer.remaining();
                        for (n2 = 0; n2 < n3; ++n2) {
                            byteBuffer.put(this.readAhead.get());
                        }
                    }
                    n2 = n3;
                    return n2;
                }
                n = this.ch.read(byteBuffer);
                if (n != 0) {
                    if (n == -1) {
                        this.eof = true;
                    }
                    int n4 = n;
                    return n4;
                }
                if (WispSocketImpl.this.so.getSoTimeout() > 0) {
                    WEA.addTimer(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(WispSocketImpl.this.so.getSoTimeout()));
                }
                do {
                    WEA.registerEvent(this.ch, 1);
                    WEA.park(-1L);
                    if (WispSocketImpl.this.so.getSoTimeout() <= 0 || !WEA.isTimeout()) continue;
                    throw new SocketTimeoutException("time out");
                } while ((n = this.ch.read(byteBuffer)) == 0);
            }
            finally {
                if (WispSocketImpl.this.so.getSoTimeout() > 0) {
                    WEA.cancelTimer();
                }
                WEA.unregisterEvent();
            }
            if (n == -1) {
                this.eof = true;
            }
            return n;
        }

        @Override
        public int available() throws IOException {
            if (this.readAhead == null) {
                this.readAhead = ByteBuffer.allocate(4096);
            } else if (this.readAhead.hasRemaining()) {
                return this.readAhead.remaining();
            }
            this.readAhead.clear();
            this.ch.read(this.readAhead);
            this.readAhead.flip();
            return this.readAhead.remaining();
        }

        @Override
        public void close() throws IOException {
            WispSocketImpl.this.close();
        }
    }
}

